% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cond_logreg.R
\name{cond_logreg}
\alias{cond_logreg}
\title{Conditional Logistic Regression with Measurement Error in One Covariate}
\usage{
cond_logreg(g = rep(1, length(xtilde1)), xtilde1, xtilde0, c1 = NULL,
  c0 = NULL, errors = "processing", approx_integral = TRUE,
  estimate_var = FALSE, start_nonvar_var = c(0.01, 1),
  lower_nonvar_var = c(-Inf, 1e-04), upper_nonvar_var = c(Inf, Inf),
  jitter_start = 0.01, hcubature_list = list(tol = 1e-08),
  nlminb_list = list(control = list(trace = 1, eval.max = 500, iter.max =
  500)), hessian_list = list(method.args = list(r = 4)),
  nlminb_object = NULL)
}
\arguments{
\item{g}{Numeric vector with pool sizes, i.e. number of members in each pool.}

\item{xtilde1}{Numeric vector (or list of numeric vectors, if some
observations have replicates) with Xtilde values for cases.}

\item{xtilde0}{Numeric vector (or list of numeric vectors, if some
observations have replicates) with Xtilde values for controls.}

\item{c1}{Numeric matrix with precisely measured covariates for cases.}

\item{c0}{Numeric matrix with precisely measured covariates for controls.}

\item{errors}{Character string specifying the errors that X is subject to.
Choices are \code{"none"}, \code{"measurement"} for measurement error,
\code{"processing"} for processing error (only relevant for pooled data), and
\code{"both"}.}

\item{approx_integral}{Logical value for whether to use the probit
approximation for the logistic-normal integral, to avoid numerically
integrating X's out of the likelihood function.}

\item{estimate_var}{Logical value for whether to return variance-covariance
matrix for parameter estimates.}

\item{start_nonvar_var}{Numeric vector of length 2 specifying starting value
for non-variance terms and variance terms, respectively.}

\item{lower_nonvar_var}{Numeric vector of length 2 specifying lower bound for
non-variance terms and variance terms, respectively.}

\item{upper_nonvar_var}{Numeric vector of length 2 specifying upper bound for
non-variance terms and variance terms, respectively.}

\item{jitter_start}{Numeric value specifying standard deviation for mean-0
normal jitters to add to starting values for a second try at maximizing the
log-likelihood, should the initial call to \code{\link[stats]{nlminb}} result
in non-convergence. Set to \code{NULL} for no second try.}

\item{hcubature_list}{List of arguments to pass to
\code{\link[cubature]{hcubature}} for numerical integration. Only used if
\code{approx_integral = FALSE}.}

\item{nlminb_list}{List of arguments to pass to \code{\link[stats]{nlminb}}
for log-likelihood maximization.}

\item{hessian_list}{List of arguments to pass to
\code{\link[numDeriv]{hessian}} for approximating the Hessian matrix. Only
used if \code{estimate_var = TRUE}.}

\item{nlminb_object}{Object returned from \code{\link[stats]{nlminb}} in a
prior call. Useful for bypassing log-likelihood maximization if you just want
to re-estimate the Hessian matrix with different options.}
}
\value{
List containing:
\enumerate{
\item Numeric vector of parameter estimates.
\item Variance-covariance matrix (if \code{estimate_var = TRUE}).
\item Returned \code{\link[stats]{nlminb}} object from maximizing the
log-likelihood function.
\item Akaike information criterion (AIC).
}
}
\description{
Compatible with individual or pooled measurements. Assumes a normal linear
model for exposure given other covariates, and additive normal errors.
}
\examples{
# Load simulated data for 150 case pools and 150 control pools
data(dat_cond_logreg)
dat <- dat_cond_logreg$dat
xtilde1 <- dat_cond_logreg$xtilde1
xtilde0 <- dat_cond_logreg$xtilde0

# Fit conditional logistic regression to estimate log-odds ratio for X and Y
# adjusted for C, using the precise poolwise summed exposure X. True log-OR
# for X is 0.5.
truth <- cond_logreg(
  g = dat$g,
  xtilde1 = dat$x1,
  xtilde0 = dat$x0,
  c1 = dat$c1.model,
  c0 = dat$c0.model,
  errors = "neither"
)
truth$theta.hat

# Suppose X is subject to additive measurement error and processing error,
# and we observe Xtilde1 and Xtilde0 rather than X1 and X0. Fit model with
# Xtilde's, accounting for errors (numerical integration avoided by using
# probit approximation).
\dontrun{
corrected <- cond_logreg(
  g = dat$g,
  xtilde1 = xtilde1,
  xtilde0 = xtilde0,
  c1 = dat$c1.model,
  c0 = dat$c0.model,
  errors = "both",
  approx_integral = TRUE
)
corrected$theta.hat
}


}
\references{
Saha-Chaudhuri, P., Umbach, D.M. and Weinberg, C.R. (2011) "Pooled exposure
assessment for matched case-control studies." \emph{Epidemiology}
\strong{22}(5): 704--712.

Schisterman, E.F., Vexler, A., Mumford, S.L. and Perkins, N.J. (2010) "Hybrid
pooled-unpooled design for cost-efficient measurement of biomarkers."
\emph{Stat. Med.} \strong{29}(5): 597--613.

Weinberg, C.R. and Umbach, D.M. (1999) "Using pooled exposure assessment to
improve efficiency in case-control studies." \emph{Biometrics} \strong{55}:
718--726.

Weinberg, C.R. and Umbach, D.M. (2014) "Correction to 'Using pooled exposure
assessment to improve efficiency in case-control studies' by Clarice R.
Weinberg and David M. Umbach; 55, 718--726, September 1999."
\emph{Biometrics} \strong{70}: 1061.
}
