% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative_poisson_net_survival.R
\name{rpcurve}
\alias{rpcurve}
\title{Marginal piecewise parametric relative survival curve}
\usage{
rpcurve(object = NULL)
}
\arguments{
\item{object}{a \code{relpois} object}
}
\description{
Fit a marginal relative survival curve based on a \code{relpois} fit
}
\details{
\pkg{popEpi} version 0.2.1 supported confidence intervals but due to lack
of testing this is disabled until the intervals are subjected to more rigorous testing.

Currently only estimates a marginal curve, i.e. the average of all
possible individual curves. 

Only supported when the reserved \code{FOT} variable was used in \code{relpois}.
Computes a curve for each unique combination of covariates (e.g. 4 sets) 
and returns a weighted average curve based on the counts
of subjects for each combination (e.g. 1000, 125, 50, 25 respectively). 
Fairly fast when only factor variables have been used, otherwise
go get a cup of coffee.

If delayed entry is present in data due to period analysis limiting,
the marginal curve is constructed only for those whose follow-up started
in the respective period.
}
\examples{
\dontrun{
## use the simulated rectal cancer cohort
data("sire", package = "popEpi")
ab <- c(0,45,55,65,70,Inf)
sire$agegr <- cut(sire$dg_age, breaks = ab, right = FALSE)

BL <- list(fot= seq(0,10,1/12))
pm <- data.frame(popEpi::popmort)
x <- lexpand(sire, breaks=BL, pophaz=pm, 
             birth = bi_date, 
             entry = dg_date, exit = ex_date, 
             status  = status \%in\% 1:2)

rpm <- relpois(x, formula = lex.Xst \%in\% 1:2 ~ -1+ FOT + agegr, 
               fot.breaks=c(0,0.25,0.5,1:8,10))
pmc <- rpcurve(rpm)

## compare with non-parametric estimates
names(pm) <- c("sex", "per", "age", "haz")
x$agegr <- cut(x$dg_age, c(0,45,55,65,75,Inf), right = FALSE)
st <- survtab(fot ~ adjust(agegr), data = x, weights = "internal",
              pophaz = pm)


plot(st, y = "r.e2.as")
lines(y = pmc$est, x = pmc$Tstop, col="red")
}



}
\author{
Joonas Miettinen
}
\seealso{
Other relpois_related: \code{\link{RPL}},
  \code{\link{relpois_ag}}, \code{\link{relpois}}
}

