% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative_poisson.R
\name{relpois_ag}
\alias{relpois_ag}
\title{Excess hazard Poisson model}
\usage{
relpois_ag(formula, data, d.exp, offset = NULL, breaks = NULL,
  subset = NULL, piecewise = TRUE, check = TRUE, ...)
}
\arguments{
\item{formula}{a formula with the counts of events as the response.
Passed on to \code{glm}. May contain usage of the \code{offset()} function
instead of supplying the offset for the Poisson model via the argument
\code{offset}.}

\item{data}{an \code{aggre} object (an aggregated data set; 
see \code{\link{as.aggre}} and \code{\link{aggre}})}

\item{d.exp}{the counts of expected cases. Mandatory.
E.g. \code{d.exp = EXC_CASES}, where \code{EXC_CASES} is a column in data.}

\item{offset}{the offset for the Poisson model, supplied as e.g.
\code{offset = log(PTIME)}, where \code{PTIME} is a subject-time
variable in data. Not mandatory, but almost always should be supplied.}

\item{breaks}{optional; a numeric vector of [a,b) breaks to specify
survival intervals over the follow-up time; if \code{NULL}, the 
existing breaks along the mandatory time scale mentioned in \code{formula}
are used}

\item{subset}{a logical vector or condition; e.g. \code{subset = sex == 1};
limits the data before estimation}

\item{piecewise}{\code{logical}; if \code{TRUE}, and if any time scale
from data is used (mentioned) in the formula, the time scale is 
transformed into a factor variable indicating intervals on the time scale.
Otherwise the time scale left as it is, usually a numeric variable.
E.g. if \code{formula = counts ~ TS1*VAR1}, \code{TS1} is transformed
into a factor before fitting model.}

\item{check}{\code{logical}; if \code{TRUE}, performs check on the 
negativity excess cases by factor-like covariates in formula - 
negative excess cases will very likely lead to non-converging model}

\item{...}{any other argument passed on to \code{\link[stats]{glm}} such as 
\code{control} or \code{weights}}
}
\value{
A \code{relpois} object created using a custom Poisson family construct.
}
\description{
Estimate a Poisson Piecewise Constant Excess
Hazards Model
}
\examples{
## use the simulated rectal cancer cohort
data(sire, package = "popEpi")
sire$agegr <- cut(sire$dg_age, c(0,45,60,Inf), right=FALSE)

## create aggregated example data
fb <- c(0,3/12,6/12,1,2,3,4,5)
x <- lexpand(sire, birth = bi_date, entry = dg_date,
             exit = ex_date, status=status \%in\% 1:2,
             breaks = list(fot=fb), 
             pophaz=popmort, pp = FALSE,
             aggre = list(agegr, fot))
             
## fit model using aggregated data
rpm <- relpois_ag(formula = from0to1 ~ fot + agegr,  data = x,
                  d.exp = d.exp, offset = log(pyrs))
summary(rpm)
 
## the usual functions for handling glm models work
rpm2 <- update(rpm, . ~ fot*agegr)
anova(rpm, rpm2, test="LRT")
AIC(rpm, rpm2)

## other features such as residuals or predicting are not guaranteed
## to work as intended.
}
\seealso{
\code{\link{lexpand}}, \code{\link{poisson}}, \code{\link{glm}}

Other main functions: \code{\link{rate}},
  \code{\link{relpois}}, \code{\link{sirspline}},
  \code{\link{sir}}, \code{\link{survmean}},
  \code{\link{survtab_ag}}, \code{\link{survtab}}

Other relpois functions: \code{\link{RPL}},
  \code{\link{relpois}}, \code{\link{rpcurve}}
}
\author{
Joonas Miettinen, Karri Seppa
}
\concept{main functions}
\concept{relpois functions}
