% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popkin.R
\name{popkin}
\alias{popkin}
\title{Estimate kinship from a genotype matrix and subpopulation assignments}
\usage{
popkin(X, subpops = NULL, n = NA, lociOnCols = FALSE, memLim = NA)
}
\arguments{
\item{X}{Genotype matrix, BEDMatrix object, or a function \eqn{X(m)} that returns the genotypes of all individuals at \eqn{m} successive locus blocks each time it is called, and NULL when no loci are left.}

\item{subpops}{The length-\eqn{n} vector of subpopulation assignments for each individual.  If missing, every individual is effectively treated as a different population.}

\item{n}{Number of individuals (required only when \eqn{X} is a function, ignored otherwise).  If \eqn{n} is missing but \code{subpops} is not, \eqn{n} is taken to be the length of \code{subpops}.}

\item{lociOnCols}{If true, \eqn{X} has loci on columns and individuals on rows; if false (the default), loci are on rows and individuals on columns. Has no effect if \eqn{X} is a function.  If \eqn{X} is a BEDMatrix object, \code{lociOnCols=TRUE} is set automatically.}

\item{memLim}{Memory limit in GB, used to break up genotype data into chunks for very large datasets. Note memory usage is somewhat underestimated and is not controlled strictly.  Default in Linux and Windows is 70 \% of the free system memory, otherwise it is 1GB (OSX and other systems).}
}
\value{
The estimated \eqn{n \times n}{n-by-n} kinship matrix \eqn{\Phi^T}.
}
\description{
Given the biallelic genotypes of \eqn{n} individuals, this function returns the \eqn{n \times n}{n-by-n} kinship matrix \eqn{\Phi^T} such that the kinship estimate between the most distant subpopulations is zero on average (this sets the ancestral population \eqn{T} to the most recent common ancestor population).
}
\details{
The subpopulation assignments are only used to estimate the baseline kinship (the zero value).
If the user wants to re-estimate \eqn{\Phi^T} using different subpopulation labels,
it suffices to rescale the given \eqn{\Phi^T} using \code{\link{rescalePopkin}}
(as opposed to starting from the genotypes again, which gives the same answer less efficiently).

The matrix \eqn{X} must have values only in \code{c(0,1,2,NA)}, encoded to count the number of reference alleles at the locus, or \code{NA} for missing data.
}
\examples{
## Construct toy data
X <- matrix(c(0,1,2,1,0,1,1,0,2), nrow=3, byrow=TRUE) # genotype matrix
subpops <- c(1,1,2) # subpopulation assignments for individuals

## NOTE: for BED-formatted input, use BEDMatrix!
## "file" is path to BED file (excluding .bed extension)
# library(BEDMatrix)
# X <- BEDMatrix(file) # load genotype matrix object

Phi <- popkin(X, subpops) # calculate kinship from genotypes and subpopulation labels

}
