% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avg_kinship_subpops.R
\name{avg_kinship_subpops}
\alias{avg_kinship_subpops}
\title{Calculate a kinship matrix between subpopulations by averaging individual data}
\usage{
avg_kinship_subpops(kinship, subpops, subpop_order = unique(subpops))
}
\arguments{
\item{kinship}{A symmetric \code{n}-by-\code{n} kinship matrix.}

\item{subpops}{The length-\code{n} vector of subpopulation assignments for each individual.}

\item{subpop_order}{The optional order of subpopulations in the output matrix.
\code{subpop_order} must contain every unique subpopulation in \code{subpops}.
Any additional subpopulations in \code{subpop_order} (missing in \code{subpops}) are ignored.
By default, subpopulations are in the order of first appearance in \code{subpops}.}
}
\value{
The symmetric \code{K}-by-\code{K} kinship matrix between subpopulations, where \code{K} is the number of unique subpopulations in \code{subpops}, ordered as in \code{subpop_order}.
}
\description{
This function calculates a kinship matrix between subpopulations, whose values are the average kinship values between all individual pairs where one individual is in the first subpopulation and the other individual is in the second subpopulation.
To estimate coancestry instead of kinship, which is recommended to get more interpretable diagonal values, the input kinship matrix should be transformed using \code{\link[=inbr_diag]{inbr_diag()}}.
}
\examples{
# a toy kinship matrix with 5 individuals belonging to 2 subpopulations
kinship <- matrix(
    c(
        0.7, 0.4, 0.4, 0.1, 0.0,
        0.4, 0.7, 0.4, 0.2, 0.1,
        0.4, 0.4, 0.7, 0.2, 0.0,
        0.1, 0.2, 0.2, 0.6, 0.1,
        0.0, 0.1, 0.0, 0.1, 0.6
    ),
    nrow = 5,
    ncol = 5
)
subpops <- c(1, 1, 1, 2, 2)

# calculate mean kinship between (and within) subpopulations
# a 2x2 matrix
avg_kinship_subpops( kinship, subpops )

# calculate coancestry estimate instead (difference is diagonal)
avg_kinship_subpops( inbr_diag( kinship ), subpops )

}
