% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/amova.r
\name{poppr.amova}
\alias{amova}
\alias{poppr.amova}
\title{Perform Analysis of Molecular Variance (AMOVA) on genind or genclone objects.}
\usage{
poppr.amova(x, hier = NULL, clonecorrect = FALSE, within = TRUE,
  dist = NULL, squared = TRUE, correction = "quasieuclid",
  dfname = "population_hierarchy", sep = "_", missing = "loci",
  cutoff = 0.05, quiet = FALSE)
}
\arguments{
\item{x}{a \code{\linkS4class{genind}} or \code{\linkS4class{genclone}}
  object}

\item{hier}{a hierarchical \code{\link{formula}} that defines your population
  hierarchy. (e.g.: ~Population/Subpopulation). \strong{See Details below.}}

\item{clonecorrect}{\code{logical} if \code{TRUE}, the data set will be clone
  corrected with respect to the lowest level of the hierarchy. The default is
  set to \code{FALSE}. See \code{\link{clonecorrect}} for details.}

\item{within}{\code{logical}. When this is set to \code{TRUE} (Default),
  variance within individuals are calculated as well. If this is set to
  \code{FALSE}, The lowest level of the hierarchy will be the sample level.
  See Details below.}

\item{dist}{an optional distance matrix calculated on your data.}

\item{squared}{if a distance matrix is supplied, this indicates whether or
  not it represents squared distances.}

\item{correction}{a \code{character} defining the correction method for
  non-euclidean distances. Options are \code{\link[ade4]{quasieuclid}}
  (Default), \code{\link[ade4]{lingoes}}, and \code{\link[ade4]{cailliez}}.
  See Details below.}

\item{dfname}{if the input data set is a \code{\linkS4class{genind}} object,
  specify the name of the data frame in the \code{\link[adegenet]{other}}
  slot defining the population hierarchy. Defaults to
  \code{"population_hierarchy"}}

\item{sep}{A single character used to separate the hierarchical levels. This
defaults to "_".}

\item{missing}{specify method of correcting for missing data utilizing
  options given in the function \code{\link{missingno}}. Default is
  \code{"loci"}.}

\item{cutoff}{specify the level at which missing data should be
  removed/modified. See \code{\link{missingno}} for details.}

\item{quiet}{\code{logical} If \code{FALSE} (Default), messages regarding any
  corrections will be printed to the screen. If \code{TRUE}, no messages will
  be printed.}
}
\value{
a list of class \code{amova} from the ade4 package. See
  \code{\link[ade4]{amova}} for details.
}
\description{
This function utilizes the ade4 implementation of AMOVA. See
\code{\link[ade4]{amova}} for details on the specific implementation.
}
\details{
The poppr implementation of AMOVA is a very detailed wrapper for the
  ade4 implementation. The output is an \code{\link[ade4]{amova}} class list
  that contains the results in the first four elements. The inputs are contained in the
  last three elements. The inputs required for the ade4 implementation are:
  \enumerate{
  \item a distance matrix on all unique genotypes (haplotypes)
  \item a data frame defining the hierarchy of the distance matrix
  \item  a genotype (haplotype) frequency table.}
  All of this data can be constructed from a
  \code{\linkS4class{genind}} object, but can be daunting for a novice R
  user. \emph{This function automates the entire process}. Since there are many
  variables regarding genetic data, some points need to be highlighted:

  \subsection{On Hierarchies:}{The hierarchy is defined by different hierarchical
  levels that separate your data. In a \code{\linkS4class{genclone}} object,
  these levels are inherently defined in the \code{hierarchy} slot. For
  \code{\linkS4class{genind}} objects, these levels must be defined in a data
  frame located within the \code{\link[adegenet]{other}} slot. It is best
  practice to name this data frame \code{"population_hierarchy"}.}

  \subsection{On Within Individual Variance:}{ Heterozygosities within diploid
  genotypes are sources of variation from within individuals and can be
  quantified in AMOVA. When \code{within = TRUE}, poppr will split diploid
  genotypes into haplotypes and use those to calculate within-individual
  variance. No estimation of phase is made. This acts much like the default
  settings for AMOVA in the Arlequin software package. Within individual
  variance will not be calculated for haploid individuals or dominant
  markers.}

  \subsection{On Euclidean Distances:}{ AMOVA, as defined by
  Excoffier et al., utilizes an absolute genetic distance measured in the
  number of differences between two samples across all loci. With the ade4
  implementation of AMOVA (utilized by poppr), distances must be Euclidean
  (due to the nature of the calculations). Unfortunately, many genetic
  distance measures are not always euclidean and must be corrected for before
  being analyzed. Poppr automates this with three methods implemented in
  ade4, \code{\link{quasieuclid}}, \code{\link{lingoes}}, and
  \code{\link{cailliez}}. The correction of these distances should not
  adversely affect the outcome of the analysis.}
}
\examples{
data(Aeut)
agc <- as.genclone(Aeut)
agc
amova.result <- poppr.amova(agc, ~Pop/Subpop)
amova.result
amova.test <- randtest(amova.result) # Test for significance
plot(amova.test)
amova.test
\dontrun{
amova.cc.result <- poppr.amova(agc, ~Pop/Subpop, clonecorrect = TRUE)
amova.cc.result
amova.cc.test <- randtest(amova.cc.result)
plot(amova.cc.test)
amova.cc.test
}
}
\references{
Excoffier, L., Smouse, P.E. and Quattro, J.M. (1992) Analysis of
molecular variance inferred from metric distances among DNA haplotypes:
application to human mitochondrial DNA restriction data. \emph{Genetics},
\strong{131}, 479-491.
}
\seealso{
\code{\link[ade4]{amova}} \code{\link{clonecorrect}}
  \code{\link{diss.dist}} \code{\link{missingno}}
  \code{\link[ade4]{is.euclid}} \code{\link{sethierarchy}}
}
\keyword{amova}

