% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distances.r
\name{diss.dist}
\alias{diss.dist}
\title{Calculate a distance matrix based on relative dissimilarity}
\usage{
diss.dist(x, percent = FALSE, mat = FALSE)
}
\arguments{
\item{x}{a \code{\link{genind}} object.}

\item{percent}{\code{logical}. Should the distance be represented as a
  percent? If set to \code{FALSE} (default), the distance will be reflected
  as the number of alleles differing between to individuals. When set to
  \code{TRUE}, These will be divided by the ploidy multiplied  by the number
  of loci.}

\item{mat}{\code{logical}. Return a matrix object. Default set to
  \code{FALSE}, returning a dist object. \code{TRUE} returns a matrix object.}
}
\value{
Pairwise distances between individuals present in the genind object.
}
\description{
diss.dist uses the same discreet dissimilarity matrix utilized by the index
of association (see \code{\link{ia}} for details). By default, it returns a
distance reflecting the number of allelic differences between two
individuals. When \code{percent = TRUE}, it returns a ratio of the number of
observed differences by the number of possible differences. Eg. two
individuals who share half of the same alleles will have a distance of 0.5.
This function can analyze distances for any marker system.
}
\note{
When \code{percent = TRUE}, this is exactly the same as
  \code{\link{provesti.dist}}, except that it performs better for large
  numbers of individuals (n > 125) at the cost of available memory.
}
\examples{
# A simple example. Let's analyze the mean distance among populations of A.
# euteiches.

data(Aeut)
mean(diss.dist(popsub(Aeut, 1)))
\dontrun{
mean(diss.dist(popsub(Aeut, 2)))
mean(diss.dist(Aeut))
}
}
\author{
Zhian N. Kamvar
}

