% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_D.R
\name{pp_D}
\alias{pp_D}
\title{Calculate Population Density}
\usage{
pp_D(source, target, sourcecode, sourcepop, area, point = FALSE)
}
\arguments{
\item{source}{object of class \code{sf}}

\item{target}{object of class \code{sf}}

\item{sourcecode}{source zone id field}

\item{sourcepop}{source zone population field}

\item{area}{target zone area field}

\item{point}{logical - whether to use point geometries or not}
}
\value{
an object of class \code{sf} including density values for each source zone id
}
\description{
Calculate Population Density
}
\examples{
    library(populR)

    data('source')
    data('target')

    # area calculation
    pp_area <- pp_a(target = target)

    # density calculation using area
    pp_density_a <- pp_D(source = source, target = pp_area, sourcecode = sid,
        sourcepop = pop, area = pp_a)

    # volume calculation
    pp_volume <- pp_a(target = target, volume = floors)

    # density calculation using volume
    pp_density_v <- pp_D(source = source, target = pp_volume, sourcecode = sid,
        sourcepop = pop, area = pp_a)

}
