% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age.R
\name{combine_age}
\alias{combine_age}
\title{Aggregate Age Group Labels}
\usage{
combine_age(x, to = c("five", "lt"))
}
\arguments{
\item{x}{A vector of age labels}

\item{to}{Type of age classification
to convert to: \code{"five"} or \code{"lt"}.
Defaults to \code{"five"}.}
}
\value{
If \code{x} is a factor, then \code{combine_age()}
returns a factor; otherwise it returns a
character vector.
}
\description{
Convert age group labels to a less detailed classification.
The three classifications recognized by \code{combine_age()}
are \code{"single"}, \code{"five"}, and \code{"lt"}, as defined on
\code{\link[=age_labels]{age_labels()}}. The following conversions are permitted:
\itemize{
\item \code{"single"} ---> \code{"lt"}
\item \code{"single"} ---> \code{"five"}
\item \code{"lt"} ---> \code{"five"}
}
}
\examples{
x <- c("0", "5", "3", "12")
combine_age(x)
combine_age(x, to = "lt")
}
\seealso{
\itemize{
\item \code{\link[=age_labels]{age_labels()}} to create age group labels
\item \code{\link[=reformat_age]{reformat_age()}} to convert existing age group labels
to a standard format
\item \code{\link[=set_age_open]{set_age_open()}} to set the lower limit
of the open age group
}
}
