% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4_classes.R
\name{risk_estimates}
\alias{risk_estimates}
\alias{risk_estimates,portvine_roll-method}
\alias{risk_estimates,cond_portvine_roll-method}
\title{Accessor methods for the risk estimates of \verb{(cond_)portvine_roll} objects}
\usage{
risk_estimates(
  roll,
  risk_measures = NULL,
  alpha = NULL,
  df = TRUE,
  exceeded = FALSE,
  ...
)

\S4method{risk_estimates}{portvine_roll}(
  roll,
  risk_measures = NULL,
  alpha = NULL,
  df = TRUE,
  exceeded = FALSE
)

\S4method{risk_estimates}{cond_portvine_roll}(
  roll,
  risk_measures = NULL,
  alpha = NULL,
  df = TRUE,
  exceeded = FALSE,
  cond = TRUE,
  cond_u = NULL
)
}
\arguments{
\item{roll}{Object of class \code{portvine_roll} or a child class}

\item{risk_measures}{Character vector of risk measures to filter for. Note
that they must be fitted in the \code{roll} argument. The default will return all
fitted risk measures}

\item{alpha}{Numeric \eqn{\alpha} levels of the estimated risk measures to
filter
for. Note that they must be fitted in the \code{roll} argument. The default will
return all fitted \eqn{\alpha} levels}

\item{df}{Logical value if \code{TRUE} a \code{data.frame} is returned otherwise a
\code{data.table} is returned.}

\item{exceeded}{Logical value. If set to \code{TRUE} a column named \code{exceeded}
will be appended that contains logical values telling whether the realized
portfolio value exceeded the estimated risk.}

\item{...}{Additional parameters for child class methods}

\item{cond}{If set to TRUE returns the conditional risk estimates and
otherwise returns the overall risk estimates.}

\item{cond_u}{Numeric or character vector specifying the corresponding
quantiles
in (0,1) of the conditional variable(s) conditioned on which the conditional
risk measures were calculated to filter for and/or the class
"prior_resid"/"resid".
Note that they must be fitted in the \code{roll} argument.
The default will return all fitted risk measures.}
}
\value{
(Un-)filtered \code{data.frame} or \code{data.table} (see \code{df} argument) with
at least the columns
\code{risk_measure}, \code{risk_est}, \code{alpha}, \code{row_num}, \code{vine_window} and \code{realized}.
\code{exceeded} column if the corresponding argument is set to \code{TRUE}.
In the conditional case further columns are available (see:
\code{\linkS4class{portvine_roll}}).
}
\description{
Accessor methods for the risk estimates of \verb{(cond_)portvine_roll} objects
}
\seealso{
\code{\linkS4class{portvine_roll}}
}
