% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POSetMeet.R
\name{POSetMeet}
\alias{POSetMeet}
\title{Computing meet (greatest lower bound).}
\usage{
POSetMeet(poset, elements)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet}.
Argument \code{poset} must be created by using any function contained in the package
aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...).}

\item{elements}{A list of character strings (the names of some poset elements).}
}
\value{
A character string (the name of the meet).
}
\description{
The function computes the meet (if existing) of a set of elements, in the input poset.
}
\examples{
elems <- c("a", "b", "c", "d", "e")

doms <- matrix(c(
  "a", "b",
  "c", "b",
  "c", "e",
  "b", "d",
  "a", "d",
  "c", "d",
  "a", "a",
  "b", "b",
  "c", "c",
  "d", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = elems, dom = doms)

glb<-POSetMeet(pos, c("b", "e"))

}
