% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvar-dist.R
\name{rvar-dist}
\alias{rvar-dist}
\alias{density.rvar}
\alias{cdf.rvar}
\alias{quantile.rvar}
\title{Density, CDF, and quantile functions of random variables}
\usage{
\method{density}{rvar}(x, at, ...)

\method{cdf}{rvar}(x, q, ...)

\method{quantile}{rvar}(x, probs, ...)
}
\arguments{
\item{x}{(rvar) An \code{\link{rvar}} object.}

\item{...}{Additional arguments passed onto underlying methods:
\itemize{
\item For \code{density()}, these are passed to \code{\link[stats:density]{stats::density()}}.
\item For \code{cdf()}, these are ignored.
\item For \code{quantile()}, these are passed to \code{\link[stats:quantile]{stats::quantile()}}.
}}

\item{q, at}{(numeric vector) One or more quantiles.}

\item{probs}{(numeric vector) One or more probabilities in \verb{[0,1]}.}
}
\value{
If \code{x} is a scalar \code{\link{rvar}}, returns a vector of the same length as the input
(\code{q}, \code{at}, or \code{probs}) containing values from the corresponding function
of the given \code{\link{rvar}}.

If \code{x} has length greater than 1, returns an array with dimensions
\code{c(length(y), dim(x))} where \code{y} is \code{q}, \code{at}, or \code{probs}, where each
\code{result[i,...]} is the value of the corresponding function,\code{f(y[i])}, for
the corresponding cell in the input array, \code{x[...]}.
}
\description{
The probability density function (\code{density()}), cumulative distribution
function (\code{cdf()}), and quantile function / inverse CDF (\code{quantile()}) of
an \code{\link{rvar}}.
}
\examples{

set.seed(1234)
x = rvar(rnorm(100))

density(x, seq(-2, 2, length.out = 10))
cdf(x, seq(-2, 2, length.out = 10))
quantile(x, ppoints(10))

x2 = c(rvar(rnorm(100, mean = -0.5)), rvar(rnorm(100, mean = 0.5)))
density(x2, seq(-2, 2, length.out = 10))
cdf(x2, seq(-2, 2, length.out = 10))
quantile(x2, ppoints(10))

}
