% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_subset.R
\name{post_subset}
\alias{post_subset}
\title{Extract samples from specific nodes}
\usage{
post_subset(
  post,
  params,
  matrix = FALSE,
  iters = FALSE,
  chains = FALSE,
  auto_escape = TRUE
)
}
\arguments{
\item{post}{A \code{\link[coda:mcmc.list]{mcmc.list}} object.}

\item{params}{A vector of regular expressions specifying the nodes to match for subsetting.
Accepts multi-element vectors to match more than one node at a time.
See \code{\link[=match_params]{match_params()}} and \code{vignette("pattern-matching")} for more details.}

\item{matrix}{Return samples in \code{\link[base:matrix]{matrix}} rather than \code{\link[coda:mcmc.list]{mcmc.list}} format?}

\item{iters}{Retain the iteration number of each sample if \code{matrix = TRUE}? Not used otherwise.}

\item{chains}{Retain the chain number of each sample if \code{matrix = TRUE}? Not used otherwise.}

\item{auto_escape}{Automatically escape \code{"["} and \code{"]"} characters for pattern matching?
See \code{\link[=match_params]{match_params()}} for details.}
}
\value{
A \code{\link[coda:mcmc.list]{mcmc.list}} or \code{\link[base:matrix]{matrix}} object, depending on the
value of the \code{matrix} argument. Object contains all nodes that match the \code{params} argument;
an error will be returned if no matches are found.
}
\description{
Subsets a smaller portion from a \code{\link[coda:mcmc.list]{mcmc.list}} object
corresponding only to the node(s) requested.
}
\examples{
# load example mcmc.list
data(cjs)

# create mcmc.list with all nodes that contain "B0"
x1 = post_subset(cjs, "B0")

# create mcmc.list with all nodes that contain "b" or "B"
x2 = post_subset(cjs, c("b", "B"))

# perform the subset and return a matrix as output, while retaining the chain ID
x3 = post_subset(cjs, "B0", matrix = TRUE, chain = TRUE)
}
\seealso{
\code{\link[=match_params]{match_params()}}
}
