% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace_plot.R
\name{trace_plot}
\alias{trace_plot}
\title{Create a trace plot for a single desired node}
\usage{
trace_plot(post, param, keep_percent = 1)
}
\arguments{
\item{post}{A \code{\link[coda:mcmc.list]{mcmc.list}} object.}

\item{param}{A regular expression that matches a single element in the model.
E.g., \code{"b0[1]"}, not \code{"b0"}. See \code{\link[=match_params]{match_params()}}.}

\item{keep_percent}{A numeric vector of length == 1 and on the range (0,1].
Percent of samples you'd like to keep for trace plotting and passed to \code{\link[=post_thin]{post_thin()}}.}
}
\description{
Create a trace plot for a single desired node
}
\note{
If saving as a pdf file, these files can get very large with many samples and render slowly.
The \code{keep_percent} argument is intended to help with this by thinning the chains at quasi-evenly spaced intervals.
This is \strong{not} a function users will generally use directly. Call \code{\link[=diag_plots]{diag_plots()}} instead.
}
