% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_query_string_cl.R
\name{build_query_string_cl}
\alias{build_query_string_cl}
\title{build_query_string_cl
Create povcalnet query string for country level, survey year specification}
\usage{
build_query_string_cl(country, povline, year, ppp = NULL,
  coverage_type = NULL, format = "json")
}
\arguments{
\item{country}{character: Requested country. Use \href{https://www.iban.com/country-codes}{iso3 codes }}

\item{povline}{numeric: Requested poverty lines in international dollars}

\item{year}{numeric: Requested survey years}

\item{ppp}{numeric: Optional - Custom PPP exchange rates (Purchasing Power parity)}

\item{coverage_type}{character: Optional - Type of data coverage. Take one to the following values
rural; urban; national; special_cpi; aggregated_distribution, invalid_ppp}

\item{format}{character: Response format to be requested from the API:
`csv` or `json`}
}
\value{
character
}
\description{
build_query_string_cl
Create povcalnet query string for country level, survey year specification
}
\examples{

build_query_string_cl(country = c("ALB", "CHN"),
povline = c(1.9, 2.0),
year = c(2002, 2002))
}
