% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user-help.R
\name{check_Phi}
\alias{check_Phi}
\title{Check interpretation `Phi` argument}
\usage{
check_Phi(Phi)
}
\arguments{
\item{Phi}{A matrix, with standardized autoregressive effects (on the diagonal) and cross-lagged effects (off-diagonal) in the population. Columns represent predictors and rows represent outcomes.}
}
\value{
No return value, called for side effects.
}
\description{
Write a textual interpretation of the values in `Phi`. This can be used to check if `Phi` has been correctly specified.
}
\examples{
# Correctly specified `Phi`
Phi1 <- matrix(c(.4, .1, .2, .3), ncol = 2, byrow = TRUE)
check_Phi(Phi1)

# `Phi` with too large standardized effects
Phi2 <- matrix(c(.6, .5, .4, .7), ncol = 2, byrow = TRUE)
Phi2 <- check_Phi(Phi2)
}
