% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_mineralogy.R
\name{summarise_mineralogy}
\alias{summarise_mineralogy}
\title{Summarise the mineralogy from multiple powdRfps and powdRafps outputs}
\usage{
summarise_mineralogy(x, type, order, rwp, r, delta)
}
\arguments{
\item{x}{a list of \code{powdRfps} or \code{powdRafps} objects.}

\item{type}{a string specifying whether the table uses all phase ID's, or
summarises them according to the phase name. One of \code{"all"} or \code{"grouped"}.}

\item{order}{a logical operator denoting whether the columns of the resulting summary
table are ordered in descending order according to the summed abundance of each phase
across the dataset.}

\item{rwp}{a logical operator denoting whether to include the Rwp value as the final column
in the output. This provides an objective measure of the difference between the fitted
and measured patterns.}

\item{r}{a logical operator denoting whether to include the R value as the final column
in the output. This provides an objective measure of the difference between the fitted
and measured patterns.}

\item{delta}{a logical operator denoting whether to include the Delta value as the final column
in the output. This provides an objective measure of the difference between the fitted
and measured patterns.}
}
\value{
A data frame
}
\description{
\code{summarise_mineralogy} creates a summary table of quantified mineral
concentrations across a given dataset using a list of multiple \code{powdRfps}
or \code{powdRafps} derived from \code{fps()} and \code{afps()}, respectively.
}
\examples{
data(minerals)
data(soils)

\dontrun{
multiple_afps <- lapply(soils, afps,
                        lib = minerals,
                        std = "QUA.1",
                        align = 0.2,
                        lod = 0.1,
                        amorphous = "ORG",
                        amorphous_lod = 1)

sm1 <- summarise_mineralogy(multiple_afps,
                            type = "all",
                            order = TRUE)

sm2 <- summarise_mineralogy(multiple_afps,
                            type = "grouped",
                            order = TRUE)

sm3 <- summarise_mineralogy(multiple_afps,
                            type = "grouped",
                            order = TRUE,
                            rwp = TRUE)
}
}
