% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEFT.R
\name{get_DEFT}
\alias{get_DEFT}
\alias{get_DEFT.plcp_3lvl}
\title{Calculate the design effect and Type I errors}
\usage{
get_DEFT(object)

\method{get_DEFT}{plcp_3lvl}(object)
}
\arguments{
\item{object}{A \code{plcp_3lvl}-object created by \code{\link{study_parameters}}}
}
\value{
A \code{data.frame} with the columns \code{n1, n2, n3, icc_slope,
var_ratio, DEFT}, and, \code{approx_type1}. The number of rows of the
\code{data.frame} will be equals to the number of
different combination of parameters values specified with \link{study_parameters}.
}
\description{
This functions helps to evaluate the consequences of ignoring a random slope
at the cluster level.
}
\details{
The design effect (DEFT) is the ratio of the standard error from the correct
three-level model to the standard error from the misspecified model omitting
the cluster-level random slope. The standard error for the misspecified model is
calculated by assuming that the cluster-level random slope variance is added
to the subject-level random slope.

The approximate type 1 error under the miss-specified model is also calculated.
The effect of wrongly ignoring a third-level random slope on the type 1 errors, depends on
\code{n1, n2, n3, icc_slope}, and, \code{var_ratio}.
}
\examples{
paras <- study_parameters(n1 = 11,
                          n2 = 30,
                          n3 = 3,
                          T_end = 10,
                          icc_pre_subject = 0.5,
                          icc_pre_cluster = 0,
                          icc_slope = c(0.01,0.05, 0.1),
                          var_ratio = 0.02)

get_DEFT(paras)
}
\seealso{
\code{\link{simulate.plcp}}
}
