% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MatpowV3.R
\name{Matpow}
\alias{Matpow}
\title{Matrix Power}
\usage{
Matpow(M, numer, denom = 1, expmethod = "Higham08.b",
  logmethod = "Higham08")
}
\arguments{
\item{M}{a square matrix}

\item{numer}{numerator of exponent. Can be a decimal or complex number.}

\item{denom}{denominator of exponent (1 by default). Can be a decimal or complex number.}

\item{expmethod}{method chosen to compute the matrix exponential if matrix is known to be
non-diagonalizable. The default method is the same as in function \code{expm} from package \pkg{expm}.}

\item{logmethod}{method chosen to compute the matrix logarithm if matrix is known to be
non-diagonalizable. The default method is the same as in function \code{logm} from package \pkg{expm}.}
}
\value{
The solution to the exponentiation operation supplied.
For diagonalizable matrices, \code{Matpow} returns a real-valued root whenever possible
(otherwise, the principal complex root).
}
\description{
Raises a valid Matrix to any power (even complex).
Valid matrices are square matrices that are diagonalizable or whose real eigenvalues are positive.
}
\details{
If the matrix is diagonalizable, the method used is based on spectral decomposition;
if the matrix is not diagonalizable, the method used is based on matrix exponentials and logarithms,
calling functions \code{matexp} and \code{matlog}, both from package \pkg{complexplus}.
The particular method used to compute the matrix exponential and logarithm may be chosen from the options available
in functions \code{expm} and \code{logm} respectively, both from package \pkg{expm}.
Note that \code{Matpow}, by extension, allows one to compute roots and the matrix inverse (if invertible).
}
\examples{
A <- matrix(1:4, ncol = 2)

Matpow(A, 3)
Matpow(A, 0.5)
Matpow(A, 0.2)
Matpow(A, 1, 5)
Matpow(A, 2, 4, expmethod = "Pade", logmethod = "Eigen") #inocuous, as A is diagonalizable
Matpow(A, -1)
Matpow(A, 2+5i)
Matpow(A, 3i)
Matpow(A, 1+2i)
Matpow(A, 3i, 2+7i)

B <- matrix(sample(1:100, 81), ncol = 9)
Matpow(B, 2)
Matpow(B, 0.5)
Matpow(B, 4, 5)
Matpow(B, pi)
Matpow(B, 0.73)
Matpow(B, -1)
Matpow(B, 7+2i)
Matpow(B, 4i, 1+3i)

C <- matrix(c(1, 0, 1, 1), ncol = 2) # A non-diagonalizable matrix
Matpow(C, 3)
Matpow(C, 0.5)
Matpow(C, 4, 8, expmethod = "Taylor", logmethod = "Eigen")
Matpow(C, 0.5*pi)
Matpow(C, 0.24)
Matpow(C, -2)
Matpow(C, 3+5i)
Matpow(C, 2i, 1+9i)

}
\author{
Albert Dorador
}
\references{
For more on spectral decomposition (also known as eigendecomposition), visit
\url{http://mathworld.wolfram.com/EigenDecomposition.html}
}
\seealso{
\code{\link[complexplus]{matexp}}
\code{\link[complexplus]{matlog}}
\code{\link[expm]{expm}}
\code{\link[expm]{logm}}
}

