% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addFossil.R
\name{addFossil}
\alias{addFossil}
\title{addFossil}
\usage{
addFossil(tree, mintime = 0, maxtime = NA, name = "fossil", edge = NA)
}
\arguments{
\item{tree}{An object of the class "phylo"}

\item{mintime}{The minimum age of the fossil. If no minimum time is specified, the default value is 0.}

\item{maxtime}{The maximum age of the fossil. If no maximum time is specified, the default value is the maximum tree age.}

\item{name}{The name of the fossil to appear as a tip.label.}

\item{edge}{The edge on the tree where the fossil presumably diverged. If no edge is specified, then the function randomly selects an edge within the age range of the fossil.}
}
\value{
An object of the class "phylo".
}
\description{
Adds a fossil as a tip to a specified phylogeny given either an age range that the fossil occurs in, a specific edge that the fossil diverged from, or both. If the specific edge placement for the fossil is unknown, then this function randomly places the fossil on any edge that is within the age range.
}
\details{
There are several random components to this function. First, if an edge is not specified to place a fossil, then an edge is randomly selected that is within the age range of the fossil. Second, the exact placement of the node leading to the fossil is randomly selected within the age range specified. Third, the length of the edge leading to the fossil is randomly selected with constraints on the maximum length of the edge, where the maximum length of the edge cannot render the fossil younger than the minimum time of occurrence as specified in the mintime argument.
}
\examples{
mytree <- phytools::pbtree(n=20)
newtree <- addFossil(mytree, mintime = max(mytree$edge.length)/2, maxtime= max(mytree$edge.length))
plot(newtree)
}
\author{
A. Michelle Lawing, Alexandra F. C. Howard
}
