% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEnvelopes.R
\name{getEnvelopes}
\alias{getEnvelopes}
\title{getEnvelopes}
\usage{
getEnvelopes(treedata_min, treedata_max, node_est)
}
\arguments{
\item{treedata_min}{tree data object with min estimate of the climate envelope for each species.}

\item{treedata_max}{tree data object with max estimate of the climate envelope for each species}

\item{node_est}{the estimate of all the nodes, both min and max}
}
\value{
An array containing climate envelopes for each node
}
\description{
This function gets the bioclimate envelopes of species and nodes.
}
\details{
Function derives the minimum, and maximum of each climate variable
}
\examples{
data(sampletrees)
data(occurrences)
tree <- sampletrees[[25]]
biooccu <- getBioclimVars(occurrences, which.biovars=1)
sp_data_min<- tapply(biooccu[,4],biooccu$Species,min)
sp_data_max<- tapply(biooccu[,4],biooccu$Species,max)
treedata_min <- geiger::treedata(tree,sp_data_min,sort=TRUE,warnings=F)
treedata_max <- geiger::treedata(tree,sp_data_max,sort=TRUE,warnings=F)
\donttest{full_est <- nodeEstimateEnvelopes(treedata_min,treedata_max)
node_est <- full_est$est
example_getEnvelopes <- getEnvelopes(treedata_min, treedata_max, node_est)}
}
\seealso{
\code{ppgmMESS()}, \code{nodeEstimate}, \code{geiger::treedata}
}
\author{
A. Michelle Lawing, Alexandra F. C. Howard
}
