% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGeoRates.R
\name{plotGeoRates}
\alias{plotGeoRates}
\title{plotGeoRates}
\usage{
plotGeoRates(geo_center, geo_size, time_int, trees, path="")
}
\arguments{
\item{geo_center}{change in geographic center of suitable climate envelope, see}

\item{geo_size}{change in geographic size of suitable climate envelope}

\item{time_int}{time intervals to plot}

\item{trees}{distribution of phylogenies}

\item{path}{path to the directory where the results to be saved}
}
\value{
plots of geo rate
}
\description{
plotGeoRates
}
\details{
Creates plot with gray background of all pairwise comparisons of change in geo center and area through time. Blue points on top show the sequential change in geo center and expansion/contraction for all lineages
}
\examples{
data(sampletrees)
data(occurrences)
sampletrees <- sample(sampletrees,5)
biooccu <- getBioclimVars(occurrences, which.biovars=1)
sp_data_min<- tapply(biooccu[,4],biooccu$Species,min)
sp_data_max<- tapply(biooccu[,4],biooccu$Species,max)
treedata_min <- treedata_max <- node_est <- envelope <- list()
geo_center<-array(NA,dim=c(100,53,21,21))
geo_size<-array(NA,dim=c(100,53,21,21))
\donttest{for (tr in 1:length(sampletrees)){
  treedata_min[[tr]] <- geiger::treedata(sampletrees[[tr]],sp_data_min,sort=TRUE,warnings=F)
  treedata_max[[tr]] <- geiger::treedata(sampletrees[[tr]],sp_data_max,sort=TRUE,warnings=F)
  full_est <- nodeEstimateEnvelopes(treedata_min[[tr]],treedata_max[[tr]])
  node_est[[tr]] <- full_est$est
  envelope[[tr]] <- getEnvelopes(treedata_min[[tr]], treedata_max[[tr]], node_est[[tr]])
  temp <- getGeoRate(envelope[[tr]], sampletrees[[tr]], which.biovars=1)
  geo_center[tr,,,]<-temp$geo_center
  geo_size[tr,,,]<-temp$geo_size
}
}
\dontrun{plotGeoRates(geo_center, geo_size, temp$time_int, sampletrees, path="tempdir()")
}
}
\seealso{
\code{getGeoRates}
}
\author{
A. Michelle Lawing, Alexandra F. C. Howard
}
