% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppiRUS2010}
\alias{ppiRUS2010}
\title{ppiRUS2010}
\format{A data frame with 4 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nl100}}{National poverty line (100\%)}
\item{\code{extreme}}{USAID extreme poverty}
\item{\code{ppp625}}{Below $6.25 per day purchasing power parity (2005)}
}}
\source{
\url{www.povertyindex.org}
}
\usage{
ppiRUS2010
}
\description{
Poverty Probability Index (PPI) lookup table for Russia
}
\examples{
  # Access Russia PPI table
  ppiRUS2010

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiRUS2010[ppiRUS2010$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiRUS2010, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the national
  # poverty line definition
  ppiScore <- 50
  ppiRUS2010[ppiRUS2010$score == ppiScore, "nl100"]

}
\keyword{datasets}
