% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_data.R
\docType{data}
\name{ppiGHA2015_a}
\alias{ppiGHA2015_a}
\title{Poverty Probability Index (PPI) lookup table for Ghana using poverty
definitions deflated with Ghana's CPI}
\format{
A data frame with 13 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nlFood}}{Food poverty line}
\item{\code{nl100}}{National poverty line (100\%)}
\item{\code{nl150}}{National poverty line (150\%)}
\item{\code{nl200}}{National poverty line (200\%)}
\item{\code{half100}}{Poorest half below 100\% national}
\item{\code{ppp125}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp200}}{Below $2.00 per day purchasing power parity (2005)}
\item{\code{ppp250}}{Below $2.50 per day purchasing power parity (2005)}
\item{\code{ppp375}}{Below $3.75 per day purchasing power parity (2005)}
\item{\code{ppp500}}{Below $5.00 per day purchasing power parity (2005)}
\item{\code{ppp190}}{Below $1.90 per day purchasing power parity (2011)}
\item{\code{ppp310}}{Below $3.10 per day purchasing power parity (2011)}
}
}
\source{
\url{https://www.povertyindex.org}
}
\usage{
ppiGHA2015_a
}
\description{
Poverty Probability Index (PPI) lookup table for Ghana using poverty
definitions deflated with Ghana's CPI
}
\examples{
  # Access Ghana PPI table
  ppiGHA2015_a

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiGHA2015_a[ppiGHA2015_a$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiGHA2015_a, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the national
  # poverty line definition
  ppiScore <- 50
  ppiGHA2015_a[ppiGHA2015_a$score == ppiScore, "nl100"]

}
\keyword{datasets}
