% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{score_predictors}
\alias{score_predictors}
\title{Calculate predictive power scores for y
Calculates the predictive power scores for the specified \code{y} variable
using every column in the dataset as \code{x}, including itself.}
\usage{
score_predictors(df, y, ..., do_parallel = FALSE, n_cores = -1)
}
\arguments{
\item{df}{data.frame containing columns for x and y}

\item{y}{string, column name of target variable}

\item{...}{any arguments passed to \code{\link{score}}}

\item{do_parallel}{bool, whether to perform \code{\link{score}} calls in parallel}

\item{n_cores}{numeric, number of cores to use, defaults to maximum minus 1}
}
\value{
a data.frame containing \describe{
    \item{x}{the name of the predictor variable}
    \item{y}{the name of the target variable}
    \item{result_type}{text showing how to interpret the resulting score}
    \item{pps}{the predictive power score}
    \item{metric}{the evaluation metric used to compute the PPS}
    \item{baseline_score}{the score of a naive model on the evaluation metric}
    \item{model_score}{the score of the predictive model on the evaluation metric}
    \item{cv_folds}{how many cross-validation folds were used}
    \item{seed}{the seed that was set}
    \item{algorithm}{text shwoing what algorithm was used}
    \item{model_type}{text showing whether classification or regression was used}
}
}
\description{
Calculate predictive power scores for y
Calculates the predictive power scores for the specified \code{y} variable
using every column in the dataset as \code{x}, including itself.
}
\examples{
\donttest{score_predictors(df = iris, y = 'Species')}
\donttest{score_predictors(df = mtcars, y = 'mpg', do_parallel = TRUE, n_cores = 2)}
}
