% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/praznik.R
\docType{package}
\name{praznik-package}
\alias{praznik}
\alias{praznik-package}
\title{Collection of Information-Based Feature Selection Filters}
\description{
Praznik is a collection of feature selection filters performing greedy optimisation of mutual information-based usefulness criteria.
}
\details{
In a nutshell, an algorithm of this class requires an information system \eqn{(X,Y)} and a predefined number of features to selected \eqn{k}, and works like this.
To start, it estimates mutual information between each feature and the decision, find a feature with maximal such score and stores it as a first on a list of selected features, \eqn{S}.
Then, it estimates a value of a certain criterion function \eqn{J(X,Y,S)} for each feature \eqn{X}; this function also depends on \eqn{Y} and the set of already selected features \eqn{S}.
As in the first step, the previously unselected feature with a greatest value of the criterion function is selected next.
This is repeated until the method would gather \eqn{k} features, or, in case of some methods, when no more informative features can be found.
The methods implemented in praznik consider the following criteria.

The mutual information maximisation filter, \code{\link{MIM}}, simply selects top-\eqn{k} features of best mutual information, that is
\deqn{J_{MIM}=I(X;Y).}

The minimal conditional mutual information maximisation proposed by F. Fleauret, \code{\link{CMIM}}, uses
\deqn{J_{CMIM}(X)=\min_{W\in S} I(X;Y|W);}
this method is also effectively identical to the information fragments method.

The minimum redundancy maximal relevancy proposed by H. Peng et al., \code{\link{MRMR}}, uses
\deqn{J_{MRMR}=I(X;Y)-\frac{1}{|S|}\sum_{W\in S} I(X;W).}

The joint mutual information filter by H. Yang and J. Moody, \code{\link{JMI}}, uses
\deqn{J_{JMI}=\sum_{W\in S} I(X,W;Y).}

The double input symmetrical relevance filter by P. Meyer and G. Bontempi, \code{\link{DISR}}, uses
\deqn{J_{DISR}(X)=\sum_{W\in S} \frac{I(X,W;Y)}{H(X,W,Y)}.}

The minimal joint mutual information maximisation filter by M. Bennasar, Y. Hicks and R. Setchi, \code{\link{JMIM}}, uses
\deqn{J_{JMIM}=\min_{W\in S} I(X,W;Y).}

The minimal normalised joint mutual information maximisation filter by the same authors, \code{\link{NJMIM}}, uses
\deqn{J_{NJMIM}=\min_{W\in S} \frac{I(X,W;Y)}{H(X,W,Y)}.}

While \code{\link{CMIM}}, \code{\link{JMIM}} and \code{\link{NJMIM}} consider minimal value over already selected features, they may use a somewhat more sophisticated and faster algorithm.

The package also provides functions for scoring features.

\code{\link{miScores}} returns 
\deqn{I(X;Y).}

\code{\link{cmiScores}} returns, for a given condition vector \eqn{Z},
\deqn{I(X;Y|Z).}

\code{\link{jmiScores}} returns
\deqn{I(X,Z;Y).}

\code{\link{njmiScores}} returns
\deqn{\frac{I(X,Z;Y)}{H(X,Y,Z)}.}

Estimation of mutual information and its generalisations is a hard task; still, praznik aims at speed and simplicity and hence only offers basic, maximum likelihood estimator applicable on discrete data.
For convenience, praznik automatically and silently coerces non-factor inputs into about equally-spaced bins, following the heuristic often used in literature.
}
\references{
"Conditional Likelihood Maximisation: A Unifying Framework for Information Theoretic Feature Selection" G. Brown et al. JMLR (2012).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/mbq/praznik}
  \item Report bugs at \url{https://github.com/mbq/praznik/issues}
}

}
\author{
\strong{Maintainer}: Miron B. Kursa \email{M.Kursa@icm.edu.pl} (0000-0001-7672-648X)

}
