/*
 * Decompiled with CFR 0.152.
 */
package auc;

import auc.AUCCalculator;
import auc.PNPoint;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Confusion
extends Vector<PNPoint> {
    private double totPos;
    private double totNeg;

    public Confusion(double d, double d2) {
        if (d < 1.0 || d2 < 1.0) {
            this.totPos = 1.0;
            this.totNeg = 1.0;
            System.err.println("ERROR: " + d + "," + d2 + " - " + "Defaulting Confusion to 1,1");
        } else {
            this.totPos = d;
            this.totNeg = d2;
        }
    }

    public void addPRPoint(double d, double d2) throws NumberFormatException {
        if (d > 1.0 || d < 0.0 || d2 > 1.0 || d2 < 0.0) {
            throw new NumberFormatException();
        }
        double d3 = d * this.totPos;
        double d4 = (d3 - d2 * d3) / d2;
        PNPoint pNPoint = new PNPoint(d3, d4);
        if (!this.contains(pNPoint)) {
            this.add(pNPoint);
        }
    }

    public void addROCPoint(double d, double d2) throws NumberFormatException {
        if (d > 1.0 || d < 0.0 || d2 > 1.0 || d2 < 0.0) {
            throw new NumberFormatException();
        }
        double d3 = d2 * this.totPos;
        double d4 = d * this.totNeg;
        PNPoint pNPoint = new PNPoint(d3, d4);
        if (!this.contains(pNPoint)) {
            this.add(pNPoint);
        }
    }

    public void addPoint(double d, double d2) throws NumberFormatException {
        if (d < 0.0 || d > this.totPos || d2 < 0.0 || d2 > this.totNeg) {
            throw new NumberFormatException();
        }
        PNPoint pNPoint = new PNPoint(d, d2);
        if (!this.contains(pNPoint)) {
            this.add(pNPoint);
        }
    }

    public void sort() {
        if (AUCCalculator.DEBUG) {
            System.out.println("--- Sorting the datapoints !!! ---");
        }
        if (this.size() == 0) {
            System.err.println("ERROR: No data to sort....");
            return;
        }
        Object[] objectArray = new PNPoint[this.size()];
        int n = 0;
        while (this.size() > 0) {
            objectArray[n++] = (PNPoint)this.elementAt(0);
            this.removeElementAt(0);
        }
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            this.add(objectArray[i]);
        }
        PNPoint pNPoint = (PNPoint)this.elementAt(0);
        while (pNPoint.getPos() < 0.001 && pNPoint.getPos() > -0.001) {
            this.removeElementAt(0);
            pNPoint = (PNPoint)this.elementAt(0);
        }
        double d = pNPoint.getNeg() / pNPoint.getPos();
        PNPoint pNPoint2 = new PNPoint(1.0, d);
        if (!this.contains(pNPoint2) && pNPoint.getPos() > 1.0) {
            this.insertElementAt(pNPoint2, 0);
        }
        if (!this.contains(pNPoint2 = new PNPoint(this.totPos, this.totNeg))) {
            this.add(pNPoint2);
        }
    }

    public void interpolate() {
        if (AUCCalculator.DEBUG) {
            System.out.println("--- Interpolating New Points ---");
        }
        if (this.size() == 0) {
            System.err.println("ERROR: No data to interpolate....");
            return;
        }
        for (int i = 0; i < this.size() - 1; ++i) {
            PNPoint pNPoint = (PNPoint)this.elementAt(i);
            PNPoint pNPoint2 = (PNPoint)this.elementAt(i + 1);
            double d = pNPoint2.getPos() - pNPoint.getPos();
            double d2 = pNPoint2.getNeg() - pNPoint.getNeg();
            double d3 = d2 / d;
            double d4 = pNPoint.getPos();
            double d5 = pNPoint.getNeg();
            while (Math.abs(pNPoint.getPos() - pNPoint2.getPos()) > 1.001) {
                double d6 = d5 + (pNPoint.getPos() - d4 + 1.0) * d3;
                PNPoint pNPoint3 = new PNPoint(pNPoint.getPos() + 1.0, d6);
                this.insertElementAt(pNPoint3, ++i);
                pNPoint = pNPoint3;
            }
        }
    }

    public double calculateAUCPR(double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        if (AUCCalculator.DEBUG) {
            System.out.println("--- Calculating AUC-PR ---");
        }
        if (d < 0.0 || d > 1.0) {
            System.err.println("ERROR: invalid minRecall, must be between 0 and 1 - returning 0");
            return 0.0;
        }
        if (this.size() == 0) {
            System.err.println("ERROR: No data to calculate....");
            return 0.0;
        }
        double d6 = d * this.totPos;
        int n = 0;
        PNPoint pNPoint = (PNPoint)this.elementAt(n);
        PNPoint pNPoint2 = null;
        try {
            while (pNPoint.getPos() < d6) {
                pNPoint2 = pNPoint;
                pNPoint = (PNPoint)this.elementAt(++n);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("ERROR: minRecall out of bounds - exiting...");
            System.exit(-1);
        }
        double d7 = (pNPoint.getPos() - d6) / this.totPos;
        double d8 = pNPoint.getPos() / (pNPoint.getPos() + pNPoint.getNeg());
        double d9 = d7 * d8;
        if (pNPoint2 != null) {
            double d10 = pNPoint.getPos() / this.totPos - pNPoint2.getPos() / this.totPos;
            d5 = pNPoint.getPos() / (pNPoint.getPos() + pNPoint.getNeg()) - pNPoint2.getPos() / (pNPoint2.getPos() + pNPoint2.getNeg());
            d4 = d5 / d10;
            d3 = pNPoint2.getPos() / (pNPoint2.getPos() + pNPoint2.getNeg()) + d4 * (d6 - pNPoint2.getPos()) / this.totPos;
            d2 = 0.5 * d7 * (d3 - d8);
            d9 += d2;
        }
        d7 = pNPoint.getPos() / this.totPos;
        for (int i = n + 1; i < this.size(); ++i) {
            PNPoint pNPoint3 = (PNPoint)this.elementAt(i);
            d5 = pNPoint3.getPos() / this.totPos;
            d4 = pNPoint3.getPos() / (pNPoint3.getPos() + pNPoint3.getNeg());
            d3 = (d5 - d7) * d4;
            d2 = 0.5 * (d5 - d7) * (d8 - d4);
            d9 += d3 + d2;
            pNPoint = pNPoint3;
            d7 = d5;
            d8 = d4;
        }
        System.out.println("Area Under the Curve for Precision - Recall is " + d9);
        return d9;
    }

    public double calculateAUCROC() {
        if (AUCCalculator.DEBUG) {
            System.out.println("--- Calculating AUC-ROC ---");
        }
        if (this.size() == 0) {
            System.err.println("ERROR: No data to calculate....");
            return 0.0;
        }
        PNPoint pNPoint = (PNPoint)this.elementAt(0);
        double d = pNPoint.getPos() / this.totPos;
        double d2 = pNPoint.getNeg() / this.totNeg;
        double d3 = 0.5 * d * d2;
        for (int i = 1; i < this.size(); ++i) {
            PNPoint pNPoint2 = (PNPoint)this.elementAt(i);
            double d4 = pNPoint2.getPos() / this.totPos;
            double d5 = pNPoint2.getNeg() / this.totNeg;
            double d6 = (d4 - d) * d5;
            double d7 = 0.5 * (d4 - d) * (d5 - d2);
            d3 += d6 - d7;
            pNPoint = pNPoint2;
            d = d4;
            d2 = d5;
        }
        d3 = 1.0 - d3;
        System.out.println("Area Under the Curve for ROC is " + d3);
        return d3;
    }

    public void writePRFile(String string) {
        System.out.println("--- Writing PR file " + string + " ---");
        if (this.size() == 0) {
            System.err.println("ERROR: No data to write....");
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(new File(string)));
            for (int i = 0; i < this.size(); ++i) {
                PNPoint pNPoint = (PNPoint)this.elementAt(i);
                double d = pNPoint.getPos() / this.totPos;
                double d2 = pNPoint.getPos() / (pNPoint.getPos() + pNPoint.getNeg());
                printWriter.println(d + "\t" + d2);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("ERROR: IO Exception in file " + string + " - exiting...");
            System.exit(-1);
        }
    }

    public void writeStandardPRFile(String string) {
        System.out.println("--- Writing standardized PR file " + string + " ---");
        if (this.size() == 0) {
            System.err.println("ERROR: No data to write....");
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(new File(string)));
            int n = 0;
            PNPoint pNPoint = null;
            PNPoint pNPoint2 = (PNPoint)this.elementAt(n);
            for (double d = 1.0; d <= 100.0; d += 1.0) {
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                double d7 = pNPoint2.getPos() / this.totPos;
                double d8 = -1.0;
                if (d / 100.0 <= d7) {
                    if (pNPoint == null) {
                        d8 = pNPoint2.getPos() / (pNPoint2.getPos() + pNPoint2.getNeg());
                    } else {
                        d6 = pNPoint2.getPos() - pNPoint.getPos();
                        d5 = pNPoint2.getNeg() - pNPoint.getNeg();
                        d4 = d5 / d6;
                        d3 = d / 100.0 * this.totPos;
                        d2 = pNPoint.getNeg() + (d3 - pNPoint.getPos()) * d4;
                        d8 = d3 / (d3 + d2);
                    }
                    printWriter.println(d / 100.0 + "\t" + d8);
                    continue;
                }
                do {
                    pNPoint = pNPoint2;
                } while (d / 100.0 > (d7 = (pNPoint2 = (PNPoint)this.elementAt(++n)).getPos() / this.totPos));
                d6 = pNPoint2.getPos() - pNPoint.getPos();
                d5 = pNPoint2.getNeg() - pNPoint.getNeg();
                d4 = d5 / d6;
                d3 = d / 100.0 * this.totPos;
                d2 = pNPoint.getNeg() + (d3 - pNPoint.getPos()) * d4;
                d8 = d3 / (d3 + d2);
                printWriter.println(d / 100.0 + "\t" + d8);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("ERROR: IO Exception in file " + string + " - exiting...");
            System.exit(-1);
        }
    }

    public void writeROCFile(String string) {
        System.out.println("--- Writing ROC file " + string + " ---");
        if (this.size() == 0) {
            System.err.println("ERROR: No data to write....");
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(new File(string)));
            printWriter.println("0\t0");
            for (int i = 0; i < this.size(); ++i) {
                PNPoint pNPoint = (PNPoint)this.elementAt(i);
                double d = pNPoint.getPos() / this.totPos;
                double d2 = pNPoint.getNeg() / this.totNeg;
                printWriter.println(d2 + "\t" + d);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("ERROR: IO Exception in file " + string + " - exiting...");
            System.exit(-1);
        }
    }

    @Override
    public String toString() {
        String string = "";
        string = string + "TotPos: " + this.totPos + ", TotNeg: " + this.totNeg + "\n";
        for (int i = 0; i < this.size(); ++i) {
            string = string + this.elementAt(i) + "\n";
        }
        return string;
    }
}

