% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool_zzz.R
\docType{class}
\name{ToolAUCCalculator}
\alias{ToolAUCCalculator}
\title{R6 class of the AUCCalculator tool}
\format{An R6 class object.}
\usage{
ToolAUCCalculator
}
\description{
\code{ToolAUCCalculator} is a wrapper class for
the \href{http://mark.goadrich.com/programs/AUC/}{AUCCalculator} tool, which
is a Java library that provides calculations of ROC and Precision-Recall
curves.
}
\section{Inheritance}{

\code{\link{ToolIFBase}}
}

\section{Methods}{


\describe{
  \item{\code{set_jarpath(fpath)}}{
    It sets an AUCCalculator jar file.

    \describe{
      \item{\code{jarpath}}{File path of the AUCCalculator jar file,
                            e.g. \code{"/path1/path2/auc2.jar"}.}
    }
  }
}

Following seven methods are inherited from \code{\link{ToolIFBase}}. See
\code{\link{ToolIFBase}} for the method descriptions.
\itemize{
  \item \code{call((testset, calc_auc, store_res)}
  \item \code{get_toolname()}
  \item \code{get_setname()}
  \item \code{get_result()}
  \item \code{get_x()}
  \item \code{get_y()}
  \item \code{get_auc()}
}
}
\examples{
## Initialization
toolauccalc <- ToolAUCCalculator$new()

## Show object info
toolauccalc

## create_toolset should be used for benchmarking and curve evaluation
toolauccalc2 <- create_toolset("AUCCalculator")

}
\seealso{
This class is derived from \code{\link{ToolIFBase}}.
   \code{\link{create_toolset}} for creating a list of tools.
}
\keyword{datasets}

