% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_interface.R
\name{create_testset}
\alias{create_testset}
\title{Create a list of test datasets}
\usage{
create_testset(test_type, set_names = NULL)
}
\arguments{
\item{test_type}{A single string to specify the type of dataset generated by
  this function.

  \describe{
    \item{"bench"}{Create test datasets for benchmarking}
    \item{"curve"}{Create test datasets for curve evaluation}
  }}

\item{set_names}{A character vector to specify the names of test
  datasets.

\enumerate{

  \item For benchmarking (\code{test_type = "bench"})

  This function uses a naming convention for randomly generated data for
  benchmarking. The format is a prefix ('i' or 'b') followed by the number of
  dataset. The  prefix 'i' indicates a balanced dataset, whereas 'b'
  indicates an imbalanced dataset. The number can be used with a suffix 'k'
  or 'm', indicating respectively 1000 or 1 million.

  Below are some examples.
  \describe{
    \item{"b100"}{A balanced data set with 50 positives and 50
        negatives.}
    \item{"b10k"}{A balanced data set with 5000 positives and 5000
        negatives.}
    \item{"b1m"}{A balanced data set with 500,000 positives and 500,000
        negatives.}
    \item{"i100"}{An imbalanced data set with 25 positives and 75
        negatives.}
  }

  The function returns a list of \code{\link{TestDataB}} objects.

  \item For curve evaluation (\code{test_type = "curve"})

  The following three predefined datasets can be specified for curve
  evaluation.

  \tabular{lll}{
    \strong{set name}
    \tab \strong{\code{S3} object}
    \tab \strong{data source} \cr

    c1 or C1 \tab \code{\link{TestDataC}} \tab \code{\link{C1DATA}}   \cr
    c2 or C2 \tab \code{\link{TestDataC}} \tab \code{\link{C2DATA}}   \cr
    c3 or C3 \tab \code{\link{TestDataC}} \tab \code{\link{C3DATA}}   \cr
    c4 or C4 \tab \code{\link{TestDataC}} \tab \code{\link{C4DATA}}
  }

  The function returns a list of \code{\link{TestDataC}} objects.
}}
}
\value{
A list of \code{R6} test dataset objects.
}
\description{
The \code{create_testset} function creates test datasets either for
benchmarking or curve evaluation.
}
\examples{
## Create a balanced data set with 50 positives and 50 negatives
tset1 <- create_testset("bench", "b100")

## Create an imbalanced data set with 25 positives and 75 negatives
tset2 <- create_testset("bench", "i100")

## Create P1 dataset
tset3 <- create_testset("curve", "c1")

## Create P1 dataset
tset4 <- create_testset("curve", c("c1", "c2"))

}
\seealso{
\code{\link{run_benchmark}} and \code{\link{run_evalcurve}} require
 the list of the datasets generated by this function.
 \code{\link{TestDataB}} for benchmarking test data.
 \code{\link{TestDataC}}, \code{\link{C1DATA}}, \code{\link{C2DATA}},
 \code{\link{C3DATA}}, and \code{\link{C4DATA}} for curve evaluation test data.
 \code{\link{create_usrdata}} for creating a user-defined test set.
}

