% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpe_miscs.R
\name{summary.gpe}
\alias{summary.gpe}
\title{Summary method for a General Prediction Ensemble (gpe)}
\usage{
\method{summary}{gpe}(object, penalty.par.val = "lambda.1se", ...)
}
\arguments{
\item{object}{An object of class \code{\link{gpe}}.}

\item{penalty.par.val}{character or numeric. Value of the penalty parameter
\eqn{\lambda} to be employed for selecting the final ensemble. The default
\code{"lambda.min"} employs the \eqn{\lambda} value within 1 standard
error of the minimum cross-validated error. Alternatively, 
\code{"lambda.min"} may be specified, to employ the \eqn{\lambda} value
with minimum cross-validated error, or a numeric value \eqn{>0} may be 
specified, with higher values yielding a sparser ensemble. To evaluate the 
trade-off between accuracy and sparsity of the final ensemble, inspect
\code{pre_object$glmnet.fit} and \code{plot(pre_object$glmnet.fit)}.}

\item{...}{Additional arguments, currently not used.}
}
\value{
Prints information about the fitted ensemble.
}
\description{
\code{summary.gpe} prints information about the generated ensemble 
to the command line
}
\details{
Note that the cv error is estimated with data that was also used 
for learning rules and may be too optimistic.
}
\seealso{
\code{\link{gpe}}, \code{\link{print.gpe}}, 
\code{\link{coef.gpe}}, \code{\link{predict.gpe}}
}
