% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spi.per.year.r
\name{spi.per.year}
\alias{precintcon.spi.per.year.analysis}
\alias{spi.per.year}
\title{Standardized Precipitation Index}
\usage{
spi.per.year(object, period = 3, distribution = "Gamma", FUN = mean)
}
\arguments{
\item{object}{a daily or monthly precipitation serie.}

\item{period}{the number of months to be aggregate in the calculation 
of the standardized precipitation index. (Default value: 3)}

\item{distribution}{(it has no effect yet).}

\item{FUN}{the function used to summarize the standardized 
precipitation index per year. (Default function: mean).}
}
\value{
A data.frame (precintcon.spi.per.year) containing the following variables:
\itemize{
\item \code{year} is the year.
\item \code{spi} is the standardized precipitation index.
}
}
\description{
Calculates the Standardized Precipitation Index (SPI) per 
year on a daily or monthly precipitation serie.
}
\examples{
##
# Loading the monthly precipitation serie.
data(monthly)

##
# Performing the Standardized Precipitation Index
spi.per.year(monthly, period = 3)
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{spi}}
\code{\link{read.data}}
}
\keyword{anomaly}
\keyword{index}
\keyword{precipitation}
\keyword{rainfall}

