% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATE_surv.R
\name{atefitsurv}
\alias{atefitsurv}
\title{Doubly robust estimator of and inference for the average treatment effect for survival data}
\usage{
atefitsurv(
  data,
  cate.model,
  ps.model,
  ps.method = "glm",
  ipcw.model = NULL,
  ipcw.method = "breslow",
  minPS = 0.01,
  maxPS = 0.99,
  followup.time = NULL,
  tau0 = NULL,
  surv.min = 0.025,
  n.boot = 500,
  seed = NULL,
  verbose = 0
)
}
\arguments{
\item{data}{A data frame containing the variables in the outcome, propensity score, and inverse
probability of censoring models (if specified); a data frame with \code{n} rows (1 row per observation).}

\item{cate.model}{A formula describing the outcome model to be fitted.
The outcome must appear on the left-hand side. For survival outcomes, a \code{Surv} object
must be used to describe the outcome.}

\item{ps.model}{A formula describing the propensity score (PS) model to be fitted. The treatment must
appear on the left-hand side. The treatment must be a numeric vector coded as 0/1.
If data are from a randomized controlled trial, specify \code{ps.model = ~1} as an intercept-only model.}

\item{ps.method}{A character value for the method to estimate the propensity score.
Allowed values include one of:
\code{'glm'} for logistic regression with main effects only (default), or
\code{'lasso'} for a logistic regression with main effects and LASSO penalization on
two-way interactions (added to the model if interactions are not specified in \code{ps.model}).
Relevant only when \code{ps.model} has more than one variable.}

\item{ipcw.model}{A formula describing the inverse probability of censoring weighting (IPCW)
model to be fitted. The left-hand side must be empty. Only applies for survival outcomes.
Default is \code{NULL}, which corresponds to specifying the IPCW with the same covariates
as the outcome model \code{cate.model}, plus the treatment.}

\item{ipcw.method}{A character value for the censoring model. Only applies for survival
outcomes. Allowed values are: \code{'breslow'} (Cox regression with Breslow estimator of t
he baseline survivor function), \code{'aft (exponential)'}, \code{'aft (weibull)'},
\code{'aft (lognormal)'} or \code{'aft (loglogistic)'} (accelerated failure time model
with different distributions for y variable). Default is \code{'breslow'}.}

\item{minPS}{A numerical value (in [0, 1]) below which estimated propensity scores should be
truncated. Default is \code{0.01}.}

\item{maxPS}{A numerical value (in (0, 1]) above which estimated propensity scores should be
truncated. Must be strictly greater than \code{minPS}. Default is \code{0.99}.}

\item{followup.time}{A column name in \code{data} specifying the maximum follow-up time,
interpreted as the potential censoring time. Only applies for survival outcomes.
Default is \code{NULL}, which corresponds to unknown potential censoring time.}

\item{tau0}{The truncation time for defining restricted mean time lost. Only applies for
survival outcomes. Default is \code{NULL}, which corresponds to setting the truncation time as the
maximum survival time in the data.}

\item{surv.min}{Lower truncation limit for the probability of being censored.
It must be a positive value and should be chosen close to 0. Only applies for survival
outcomes. Default is \code{0.025}.}

\item{n.boot}{A numeric value indicating the number of bootstrap samples used. Default is \code{500}.}

\item{seed}{An optional integer specifying an initial randomization seed for reproducibility.
Default is \code{NULL}, corresponding to no seed.}

\item{verbose}{An integer value indicating whether intermediate progress messages should
be printed. \code{1} indicates messages are printed and \code{0} otherwise. Default is \code{0}.}
}
\value{
Return an object of class \code{atefit} with 6 elements:
\itemize{
  \item{\code{rmst1}: } A vector of numeric values of the estimated RMST, bootstrap standard error,
  lower and upper limits of 95\% confidence interval, and the p-value in the group \code{trt=1}.
  \item{\code{rmst0}: } A vector of numeric values of the estimated RMST, bootstrap standard error,
  lower and upper limits of 95\% confidence interval, and the p-value in the group \code{trt=0}.
  \item{\code{log.rmtl.ratio}: } A vector of numeric values of the estimated log RMTL ratio of
  \code{trt=1} over \code{trt=0}, bootstrap standard error, lower and upper limits of 95\% confidence
  interval, and the p-value.
  \item{\code{log.hazard.ratio}: } A vector of numeric values of the estimated adjusted log hazard ratio
  of \code{trt=1} over \code{trt=0}, bootstrap standard error, lower and upper limits of 95\% confidence
  interval, and the p-value.
  \item{\code{trt.boot}: } Estimates of \code{rmst1}, \code{rmst0},
  \code{log.rmtl.ratio} and \code{log.hazard.ratio} in each bootstrap sample.
  \item{\code{warning}: } A warning message produced if the treatment variable was not coded as 0/1.
  The key to map the original coding of the variable to a 0/1 key is displayed in the warning to facilitate
  the interpretation of the remaining of the output.
}
}
\description{
Doubly robust estimator of the average treatment effect between two treatments, which is the
restricted mean time lost ratio for survival outcomes. Bootstrap is used for inference.
}
\details{
This helper function estimates the average treatment effect (ATE) for survival data between two
treatment groups in a given dataset. The ATE is estimated with a doubly robust estimator that accounts for
imbalances in covariate distributions between the two treatment groups with inverse probability treatment and
censoring weighting. For survival outcomes, the estimated ATE is the estimated by RMTL ratio between treatment
1 versus treatment 0. The log-transformed ATEs and log-transformed adjusted hazard ratios are returned, as well
as the estimated RMST in either treatment group. The variability of the estimated RMTL ratio is calculated
using bootstrap. Additional outputs include standard error of the log RMTL ratio, 95\% confidence interval,
p-value, and a histogram of the bootstrap estimates.
}
\examples{
\donttest{
library(survival)
tau0 <- with(survivalExample,
             min(quantile(y[trt == "drug1"], 0.95), quantile(y[trt == "drug0"], 0.95)))

output <- atefitsurv(data = survivalExample,
                     cate.model = Surv(y, d) ~ age + female +
                                  previous_cost + previous_number_relapses,
                     ps.model = trt ~ age + previous_treatment,
                     tau0 = tau0,
                     n.boot = 50,
                     seed = 999,
                     verbose = 1)
output
plot(output)
}

}
