% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_surv.R
\name{balancesurv.split}
\alias{balancesurv.split}
\title{Split the given time-to-event dataset into balanced training and validation sets (within a pre-specified tolerance)
Balanced means 1) The ratio of treated and controls is maintained in the training and validation sets
               2) The covariate distributions are balanced between the training and validation sets}
\usage{
balancesurv.split(
  y,
  d,
  trt,
  x.cate,
  x.ps,
  x.ipcw,
  yf = NULL,
  train.prop = 3/4,
  error.max = 0.1,
  max.iter = 5000
)
}
\arguments{
\item{y}{Observed survival or censoring time; vector of size \code{n}.}

\item{d}{The event indicator, normally \code{1 = event, 0 = censored}; vector of size \code{n}.}

\item{trt}{Treatment received; vector of size \code{n} with treatment coded as 0/1.}

\item{x.cate}{Matrix of \code{p.cate} baseline covariates specified in the outcome model; dimension \code{n} by \code{p.cate}.}

\item{x.ps}{Matrix of \code{p.ps} baseline covariates specified in the propensity score model; dimension \code{n} by \code{p.ps}.}

\item{x.ipcw}{Matrix of \code{p.ipw} baseline covariate specified in inverse probability of censoring weighting; dimension \code{n} by \code{p.ipw}.}

\item{yf}{Follow-up time, interpreted as the potential censoring time; vector of size \code{n} if the potential censoring time is known.
If unknown, set \code{yf == NULL} and \code{yf} will be taken as \code{y} in the function.}

\item{train.prop}{A numerical value (in (0, 1)) indicating the proportion of total data used
for training. Default is \code{3/4}.}

\item{error.max}{A numerical value > 0 indicating the tolerance (maximum value of error)
for the largest standardized absolute difference in the covariate distributions or in the
doubly robust estimated rate ratios between the training and validation sets. This is used
to define a balanced training-validation splitting. Default is \code{0.1}.}

\item{max.iter}{A positive integer value indicating the maximum number of iterations when
searching for a balanced training-validation split. Default is \code{5,000}.}
}
\value{
A list of 14 objects, 7training and 7 validation of y, trt, x.cate, x.ps, x.ipcw, time, yf:
            y.train          - observed survival or censoring time in the training set; vector of size \code{m} (observations in the training set)
            d.train          - event indicator in the training set; vector of size \code{m} coded as 0/1
            trt.train        - treatment received in the training set; vector of size \code{m} coded as 0/1
            x.cate.train     - baseline covariates for the outcome model in the training set; matrix of dimension \code{m} by \code{p.cate}
            x.ps.train       - baseline covariates (plus intercept) for the propensity score model in the training set; matrix of dimension \code{m} by \code{p.ps + 1}
            x.ipcw.train      - baseline covariates for inverse probability of censoring in the training set; matrix of dimension \code{m} by \code{p.ipw}
            yf.train         - follow-up time in the training set; if known, vector of size \code{m}; if unknown, \code{yf == NULL}
            y.valid          - observed survival or censoring time in the validation set; vector of size \code{n-m}
            d.valid          - event indicator in the validation set; vector of size \code{n-m} coded as 0/1
            trt.valid        - treatment received in the validation set; vector of size \code{n-m} coded as 0/1
            x.cate.valid     - baseline covariates for the outcome model in the validation set; matrix of dimension \code{n-m} by \code{p.cate}
            x.ps.valid       - baseline covariates (plus intercept) for the propensity score model in the validation set; matrix of dimension \code{n-m} by \code{p.ps + 1}
            x.ipcw.valid      - baseline covariates for inverse probability of censoring in the validation set; matrix of dimension \code{n-m} by \code{p.ipw}
            yf.valid         - follow-up time in the training set; if known, vector of size \code{n-m}; if unknown, \code{yf == NULL}
}
\description{
Split the given time-to-event dataset into balanced training and validation sets (within a pre-specified tolerance)
Balanced means 1) The ratio of treated and controls is maintained in the training and validation sets
               2) The covariate distributions are balanced between the training and validation sets
}
