% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{use_precommit}
\alias{use_precommit}
\title{Set up pre-commit}
\usage{
use_precommit(
  config_source = getOption("precommit.config_source"),
  force = FALSE,
  legacy_hooks = "forbid",
  open = rstudioapi::isAvailable(),
  install_hooks = TRUE,
  root = here::here()
)
}
\arguments{
\item{config_source}{Path or URL to a \code{.pre-commit-config.yaml}. This
config file will be hard-copied into \code{root}. If \code{NULL}, we check if
\code{root} is a package or project directory using
\code{\link[rprojroot:find_package_root_file]{rprojroot::find_package_root_file()}}, and resort to an appropriate default
config. See section 'Copying an existing config file'.}

\item{force}{Whether to replace an existing config file.}

\item{legacy_hooks}{How to treat hooks already in the repo which are not
managed by pre-commit. "forbid", the default, will cause  \code{use_precommit()}
to fail if there are such hooks. "allow" will run these along with
pre-commit. "remove" will delete them.}

\item{open}{Whether or not to open the .pre-commit-config.yaml after
it's been placed in your repo. The default is \code{TRUE} when working in
RStudio. Otherwise, we recommend manually inspecting the file.}

\item{install_hooks}{Whether to install environments for all available hooks.
If \code{FALSE}, environments are installed with first commit.}

\item{root}{The path to the root directory of your project.}
}
\value{
\code{NULL} (invisibly). The function is called for its side effects.
}
\description{
Get started.
}
\section{When to call this function?}{

\itemize{
\item You want to add pre-commit support to a git repo which does not have a
\code{.pre-commit-config.yaml}. This involves adding
a pre-commit config file and making sure git will call the hooks before
the next commit.
\item You cloned a repo that has a \code{.pre-commit-config.yaml} already. You need
to make sure git calls the hooks before the next commit.
}
}

\section{What does the function do?}{

\itemize{
\item Sets up a template \code{.pre-commit-config.yaml}.
\item Autoupdates the template to make sure you get the latest versions of the
hooks.
\item Installs the pre-commit script along with the hook environments with
\verb{$ pre-commit install --install-hooks}.
\item Opens the config file if RStudio is running.
}
}

\section{Copying an existing config file}{

You can use an existing \code{.pre-commit-config.yaml} file when initializing
pre-commit with \code{\link[=use_precommit]{use_precommit()}} using the argument \code{config_source} to
copy an existing config file into your repo. This argument defaults to the R
option \code{precommit.config_source}, so you may want to set this option in
your \code{.Rprofile} for convenience. Note that this is \strong{not} equivalent
to the \code{--config} option in the CLI command \verb{pre-commit install} and similar,
which do \emph{not} copy a config file into a project root (and allow to put it
under version control), but rather link it in some more or less transparent
way.
}

\examples{
\dontrun{
use_precommit()
}
}
\seealso{
Other helpers: 
\code{\link{open_config}()}
}
\concept{helpers}
