% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precrec.R
\docType{package}
\name{precrec}
\alias{precrec}
\alias{precrec-package}
\title{precrec: A package for computing accurate ROC and Precision-Recall curves}
\description{
The precrec package provides three categories of important functions:
performance measure calculations, S3 generics, and data preparation.
}
\section{Performance measure calculations}{

The \code{\link{evalmod}} function calculates ROC and Precision-Recall
 curves and returns an S3 object. The generated S3 object can be used
 with several different S3 generics, such as \code{print} and
 \code{\link{plot}}. The \code{\link{evalmod}} function can also
 calculate basic evaluation measures - error rate, accuracy, specificity,
 sensitivity, and precision.
}

\section{S3 generics}{

The precrec package provides five different S3 generics for the S3 objects
 generated by the \code{\link{evalmod}} function.

  \tabular{lll}{
    \strong{S3 generic}
    \tab \tab \strong{Library} \cr

    \code{print}           \tab \tab base \cr
    \code{\link{plot}}     \tab \tab graphics \cr
    \code{\link{autoplot}} \tab \tab ggplot2 \cr
    \code{\link{fortify}}  \tab \tab ggplot2 \cr
    \code{\link{auc}}      \tab \tab precrec
  }
}

\section{Data preparation}{

The \code{\link{mmdata}} function creates an input dataset for
 the \code{\link{evalmod}} function. The generated dataset contains
 formatted scores and labels.

\code{\link{join_scores}} and \code{\link{join_labels}} are helper
 functions to combine multiple scores and labels.

The \code{\link{create_sim_samples}} function creates test datasets with
 five different performance levels.
}

