% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etc_utils_plot.R, R/g_plot.R
\name{plot}
\alias{plot}
\alias{plot.sscurves}
\alias{plot.mscurves}
\alias{plot.smcurves}
\alias{plot.mmcurves}
\alias{plot.sspoints}
\alias{plot.mspoints}
\alias{plot.smpoints}
\alias{plot.mmpoints}
\title{Plot performance evaluation measures}
\usage{
\method{plot}{sscurves}(x, y = NULL, ...)

\method{plot}{mscurves}(x, y = NULL, ...)

\method{plot}{smcurves}(x, y = NULL, ...)

\method{plot}{mmcurves}(x, y = NULL, ...)

\method{plot}{sspoints}(x, y = NULL, ...)

\method{plot}{mspoints}(x, y = NULL, ...)

\method{plot}{smpoints}(x, y = NULL, ...)

\method{plot}{mmpoints}(x, y = NULL, ...)
}
\arguments{
\item{x}{An \code{S3} object generated by \code{\link{evalmod}}.
  The \code{plot} function accepts the following \code{S3} objects.

\enumerate{

  \item ROC and Precision-Recall curves (mode = "rocprc")

  \tabular{lll}{
    \strong{\code{S3} object}
    \tab \strong{# of models}
    \tab \strong{# of test datasets} \cr

    sscurves \tab single   \tab single   \cr
    mscurves \tab multiple \tab single   \cr
    smcurves \tab single   \tab multiple \cr
    mmcurves \tab multiple \tab multiple
  }

  \item Basic evaluation measures (mode = "basic")

  \tabular{lll}{
    \strong{\code{S3} object}
    \tab \strong{# of models}
    \tab \strong{# of test datasets} \cr

    sspoints \tab single   \tab single   \cr
    mspoints \tab multiple \tab single   \cr
    smpoints \tab single   \tab multiple \cr
    mmpoints \tab multiple \tab multiple
  }
}

See the \strong{Value} section of \code{\link{evalmod}} for more details.}

\item{y}{Equivalent with \code{curvetype}.}

\item{...}{All the following arguments can be specified.

\describe{
  \item{curvetype}{
    \enumerate{

      \item ROC and Precision-Recall curves (mode = "rocprc")
        \tabular{ll}{
          \strong{curvetype}
          \tab \strong{description} \cr

          ROC \tab ROC curve \cr
          PRC \tab Precision-Recall curve
        }
        Multiple \code{curvetype} can be combined, such as
        \code{c("ROC", "PRC")}.

      \item Basic evaluation measures (mode = "basic")
        \tabular{ll}{
          \strong{curvetype}
          \tab \strong{description} \cr

          error \tab Normalized ranks vs. error rate \cr
          accuracy \tab Normalized ranks vs. accuracy \cr
          specificity \tab Normalized ranks vs. specificity \cr
          sensitivity \tab Normalized ranks vs. sensitivity \cr
          precision \tab Normalized ranks vs. precision \cr
          mcc \tab Normalized ranks vs. Matthews correlation coefficient \cr
          fscore \tab Normalized ranks vs. F-score
       }
       Multiple \code{curvetype} can be combined, such as
       \code{c("precision", "sensitivity")}.
    }
  }
  \item{type}{
    A character to specifiy the line type as follows.
    \describe{
      \item{"l"}{lines}
      \item{"p"}{points}
      \item{"b"}{both lines and points}
    }
  }
  \item{show_cb}{
    A Boolean value to specify whether point-wise confidence
    bounds are drawn. It is effective only when \code{calc_avg} of the
    \code{\link{evalmod}} function is set to \code{TRUE}.
  }
  \item{raw_curves}{
    A Boolean value to specify whether raw curves are
    shown instead of the average curve. It is effective only
    when \code{raw_curves} of the \code{\link{evalmod}} function is set to
    \code{TRUE}.
  }
  \item{show_legend}{
    A Boolean value to specify whether the legend is shown.
  }
}}
}
\value{
The \code{plot} function shows a plot and returns NULL.
}
\description{
The \code{plot} function creates a plot of performance evaluation measures.
}
\examples{

\dontrun{
##################################################
### Single model & single test dataset
###

## Load a dataset with 10 positives and 10 negatives
data(P10N10)

## Generate an sscurve object that contains ROC and Precision-Recall curves
sscurves <- evalmod(scores = P10N10$scores, labels = P10N10$labels)

## Plot both ROC and Precision-Recall curves
plot(sscurves)

## Plot a ROC curve
plot(sscurves, curvetype = "ROC")

## Plot a Precision-Recall curve
plot(sscurves, curvetype = "PRC")

## Generate an sspoints object that contains basic evaluation measures
sspoints <- evalmod(mode = "basic", scores = P10N10$scores,
                    labels = P10N10$labels)

## Plot normalized ranks vs. basic evaluation measures
plot(sspoints)

## Plot normalized ranks vs. precision
plot(sspoints, curvetype = "precision")


##################################################
### Multiple models & single test dataset
###

## Create sample datasets with 100 positives and 100 negatives
samps <- create_sim_samples(1, 100, 100, "all")
mdat <- mmdata(samps[["scores"]], samps[["labels"]],
               modnames = samps[["modnames"]])

## Generate an mscurve object that contains ROC and Precision-Recall curves
mscurves <- evalmod(mdat)

## Plot both ROC and Precision-Recall curves
plot(mscurves)

## Hide the legend
plot(mscurves, show_legend = FALSE)

## Generate an mspoints object that contains basic evaluation measures
mspoints <- evalmod(mdat, mode = "basic")

## Plot normalized ranks vs. basic evaluation measures
plot(mspoints)

## Hide the legend
plot(mspoints, show_legend = FALSE)


##################################################
### Single model & multiple test datasets
###

## Create sample datasets with 100 positives and 100 negatives
samps <- create_sim_samples(10, 100, 100, "good_er")
mdat <- mmdata(samps[["scores"]], samps[["labels"]],
               modnames = samps[["modnames"]],
               dsids = samps[["dsids"]])

## Generate an smcurve object that contains ROC and Precision-Recall curves
smcurves <- evalmod(mdat, raw_curves = TRUE)

## Plot average ROC and Precision-Recall curves
plot(smcurves, raw_curves = FALSE)

## Hide confidence bounds
plot(smcurves, raw_curves = FALSE, show_cb = FALSE)

## Plot raw ROC and Precision-Recall curves
plot(smcurves, raw_curves = TRUE, show_cb = FALSE)

## Generate an smpoints object that contains basic evaluation measures
smpoints <- evalmod(mdat, mode = "basic")

## Plot normalized ranks vs. average basic evaluation measures
plot(smpoints)


##################################################
### Multiple models & multiple test datasets
###

## Create sample datasets with 100 positives and 100 negatives
samps <- create_sim_samples(10, 100, 100, "all")
mdat <- mmdata(samps[["scores"]], samps[["labels"]],
               modnames = samps[["modnames"]],
               dsids = samps[["dsids"]])

## Generate an mscurve object that contains ROC and Precision-Recall curves
mmcurves <- evalmod(mdat, raw_curves = TRUE)

## Plot average ROC and Precision-Recall curves
plot(mmcurves, raw_curves = FALSE)

## Show confidence bounds
plot(mmcurves, raw_curves = FALSE, show_cb = TRUE)

## Plot raw ROC and Precision-Recall curves
plot(mmcurves, raw_curves = TRUE)

## Generate an mmpoints object that contains basic evaluation measures
mmpoints <- evalmod(mdat, mode = "basic")

## Plot normalized ranks vs. average basic evaluation measures
plot(mmpoints)

}
}
\seealso{
\code{\link{evalmod}} for generating an \code{S3} object.
  \code{\link{autoplot}} for plotting the equivalent curves
  with \pkg{ggplot2}.
}
