% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertgen.R
\name{convertgen}
\alias{convertgen}
\title{Convert Genotype}
\usage{
convertgen(
  input_geno,
  type = c("hmp1", "hmp2", "num"),
  missingrate = 0.05,
  impute = TRUE
)
}
\arguments{
\item{input_geno}{genotype in HapMap format or in numeric format. The names of individuals should be provided. Missing (NA) values are allowed.}

\item{type}{the type of genotype. There are three options: "hmp1" for genotypes in HapMap format with single bit, "hmp2" for genotypes in HapMap format with double bit, and "num" for genotypes in numeric format.}

\item{missingrate}{max missing percentage for each SNP, default is 0.05.}

\item{impute}{logical. If TRUE, imputation. Default is TRUE.}
}
\value{
A matrix of genotypes in numeric format, coded as 1, 0, -1 for AA, Aa, aa. Each row represents an individual and each column represents a marker. The rownames of the matrix are the names of individuals.
}
\description{
Convert genotypes in HapMap format or in numeric format for hypred package.
}
\examples{
## load genotype in HapMap format with double bit
data(input_geno)

## convert genotype for hypred package
inbred_gen <- convertgen(input_geno, type = "hmp2")


## load genotype in numeric format
data(input_geno1)
head(input_geno1)

## convert genotype for hypred package
inbred_gen1 <- convertgen(input_geno1, type = "num")


}
