% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed.R
\name{mixed}
\alias{mixed}
\title{Solve Mixed Model}
\usage{
mixed(fix = NULL, y, kk)
}
\arguments{
\item{fix}{a design matrix of the fixed effects. If not passed, a vector of ones is added for the intercept.}

\item{y}{a vector of the phenotypic values.}

\item{kk}{a list of one or multiple kinship matrices.}
}
\value{
A list with following information is returned:

    $v_i  the inverse of the phenotypic variance-covariance matrix

    $var  estimated variance components of genetic effects

    $ve   estimated residual variance

    $beta estimated fixed effects
}
\description{
Solve linear mixed model using restricted maximum likelihood (REML). Multiple variance components can be estimated.
}
\examples{
\donttest{
## load example data from hypred package
data(hybrid_phe)
data(input_geno)

## convert original genotype
inbred_gen <- convertgen(input_geno, type = "hmp2")

## infer the additive and dominance genotypes of hybrids
gena <- infergen(inbred_gen, hybrid_phe)$add
gend <- infergen(inbred_gen, hybrid_phe)$dom

## calculate the additive and dominance kinship matrix
ka <- kin(gena)
kd <- kin(gend)

## for the additive model
parm <- mixed(y = hybrid_phe[,3], kk = list(ka))

## for the additive-dominance model
parm <- mixed(y = hybrid_phe[,3], kk = list(ka, kd))
}

}
\references{
Xu S, Zhu D and Zhang Q. (2014) Predicting hybrid performance in rice using genomic best linear unbiased prediction. Proc. Natl. Acad. Sci. USA 111, 12456-12461.
}
