% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_lines.R
\name{add_lines}
\alias{add_lines}
\title{Add lines with labels to pre-existing ggplot}
\usage{
add_lines(
  p,
  df,
  xpos = 0.3,
  add.coord.fixed = TRUE,
  lty = NULL,
  color = NULL,
  size = 0.5,
  add_theme_bw2 = TRUE,
  ...
)
}
\arguments{
\item{p}{An object of class ggplot}

\item{df}{A data.frame. Required columns are slope, intercept and label}

\item{xpos}{A numeric. Relative horizontal position}

\item{add.coord.fixed}{Logical. Whether or not add coord_fixed() function}

\item{lty}{line type}

\item{color}{line color}

\item{size}{line size}

\item{add_theme_bw2}{logical Whether or not add theme_bw2()}

\item{...}{Further arguments to be passed to geom_text}
}
\description{
Add lines with labels to pre-existing ggplot
}
\examples{
require(ggplot2)
fit=lm(mpg~wt*hp,data=mtcars)
df=calEquation(fit)
p=ggplot(data=mtcars,aes(x=wt,y=mpg))
add_lines(p,df)
add_lines(p,df,lty=1:3,color=1:3,size=1)
fit=lm(mpg~wt*vs,data=mtcars)
df=calEquation(fit)
p=ggplot(data=mtcars)+geom_point(aes(x=wt,y=mpg))
add_lines(p,df)
add_lines(p,df,lty=1:2,color=1:2,size=1)+theme_bw()
}
