% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sample.R
\name{get_sample}
\alias{get_sample}
\title{Samples data for a prediction model with a specified AUC and prevalence.}
\usage{
get_sample(auc, n_samples, prevalence, min_events = 0)
}
\arguments{
\item{auc}{The Area Under the (receiver operating characteristic) Curve.}

\item{n_samples}{Number of samples to draw.}

\item{prevalence}{Prevalence or event rate of the binary outcome as
a proportion (0.1 = 10\%).}

\item{min_events}{Minimum number of events required in the sample.}
}
\value{
Returns a \code{data.frame}.
}
\description{
Samples data for a prediction model with a specified AUC and prevalence.
}
\examples{
get_sample(0.7, 1000, 0.1)
}
