% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R, R/prediction_Arima.R,
%   R/prediction_ar.R, R/prediction_arima0.R, R/prediction_betareg.R,
%   R/prediction_clm.R, R/prediction_coxph.R, R/prediction_crch.R,
%   R/prediction_gam.R, R/prediction_gee.R, R/prediction_glm.R,
%   R/prediction_glmx.R, R/prediction_gls.R, R/prediction_hetglm.R,
%   R/prediction_hurdle.R, R/prediction_hxlr.R, R/prediction_ivreg.R,
%   R/prediction_lm.R, R/prediction_lme.R, R/prediction_loess.R,
%   R/prediction_lqs.R, R/prediction_mca.R, R/prediction_mclogit.R,
%   R/prediction_merMod.R, R/prediction_mnlogit.R, R/prediction_mnp.R,
%   R/prediction_multinom.R, R/prediction_nls.R, R/prediction_nnet.R,
%   R/prediction_plm.R, R/prediction_polr.R, R/prediction_ppr.R,
%   R/prediction_princomp.R, R/prediction_rlm.R, R/prediction_rq.R,
%   R/prediction_selection.R, R/prediction_survreg.R, R/prediction_svm.R,
%   R/prediction_svyglm.R, R/prediction_zeroinfl.R
\name{prediction-package}
\alias{prediction-package}
\alias{prediction}
\alias{prediction.default}
\alias{prediction.Arima}
\alias{prediction.ar}
\alias{prediction.arima0}
\alias{prediction.betareg}
\alias{prediction.clm}
\alias{prediction.coxph}
\alias{prediction.crch}
\alias{prediction.gam}
\alias{prediction.gee}
\alias{prediction.glm}
\alias{prediction.glmx}
\alias{prediction.gls}
\alias{prediction.hetglm}
\alias{prediction.hurdle}
\alias{prediction.hxlr}
\alias{prediction.ivreg}
\alias{prediction.lm}
\alias{prediction.lme}
\alias{prediction.loess}
\alias{prediction.lqs}
\alias{prediction.mca}
\alias{prediction.mclogit}
\alias{prediction.merMod}
\alias{prediction.mnlogit}
\alias{prediction.mnp}
\alias{prediction.multinom}
\alias{prediction.nls}
\alias{prediction.nnet}
\alias{prediction.plm}
\alias{prediction.polr}
\alias{prediction.ppr}
\alias{prediction.princomp}
\alias{prediction.rlm}
\alias{prediction.rq}
\alias{prediction.selection}
\alias{prediction.survreg}
\alias{prediction.svm}
\alias{prediction.svyglm}
\alias{prediction.zeroinfl}
\title{Extract Predictions from a Model Object}
\usage{
prediction(model, ...)

\method{prediction}{default}(model, data = find_data(model, parent.frame()),
  at = NULL, type = "response", ...)

\method{prediction}{Arima}(model, ...)

\method{prediction}{ar}(model, data, at = NULL, ...)

\method{prediction}{arima0}(model, data, at = NULL, ...)

\method{prediction}{betareg}(model, data = find_data(model, parent.frame()),
  at = NULL, type = c("response", "link", "precision", "variance",
  "quantile"), ...)

\method{prediction}{clm}(model, data = find_data(model, parent.frame()),
  at = NULL, type = NULL, category, ...)

\method{prediction}{coxph}(model, data = find_data(model, parent.frame()),
  at = NULL, type = c("risk", "expected", "lp"), ...)

\method{prediction}{crch}(model, data = find_data(model), at = NULL,
  type = c("response", "location", "scale", "quantile"), ...)

\method{prediction}{gam}(model, data = find_data(model, parent.frame()),
  at = NULL, type = c("response", "link", "terms"), ...)

\method{prediction}{gee}(model, ...)

\method{prediction}{glm}(model, data = find_data(model, parent.frame()),
  at = NULL, type = c("response", "link"), ...)

\method{prediction}{glmx}(model, data = find_data(model, parent.frame()),
  at = NULL, type = c("response", "link"), ...)

\method{prediction}{gls}(model, data = find_data(model), at = NULL, ...)

\method{prediction}{hetglm}(model, data = find_data(model, parent.frame()),
  at = NULL, type = c("response", "link", "scale"), ...)

\method{prediction}{hurdle}(model, data = find_data(model, parent.frame()),
  at = NULL, type = c("response", "count", "prob", "zero"), ...)

\method{prediction}{hxlr}(model, data = find_data(model), at = NULL,
  type = c("class", "probability", "cumprob", "location", "scale"), ...)

\method{prediction}{ivreg}(model, data = find_data(model, parent.frame()),
  at = NULL, ...)

\method{prediction}{lm}(model, data = find_data(model, parent.frame()),
  at = NULL, type = "response", ...)

\method{prediction}{lme}(model, data = find_data(model), at = NULL, ...)

\method{prediction}{loess}(model, data = find_data(model, parent.frame()),
  at = NULL, type = "response", ...)

\method{prediction}{lqs}(model, data = find_data(model), at = NULL, ...)

\method{prediction}{mca}(model, data = find_data(model), at = NULL, ...)

\method{prediction}{mclogit}(model, data = find_data(model, parent.frame()),
  at = NULL, type = c("response", "link"), ...)

\method{prediction}{merMod}(model, data = find_data(model), at = NULL,
  type = c("response", "link"), ...)

\method{prediction}{mnlogit}(model, data = find_data(model, parent.frame()),
  at = NULL, category, ...)

\method{prediction}{mnp}(model, data = find_data(model, parent.frame()),
  at = NULL, type = NULL, category, ...)

\method{prediction}{multinom}(model, data = find_data(model, parent.frame()),
  at = NULL, type = NULL, category, ...)

\method{prediction}{nls}(model, data = find_data(model, parent.frame()),
  at = NULL, ...)

\method{prediction}{nnet}(model, data = find_data(model, parent.frame()),
  at = NULL, type = NULL, category, ...)

\method{prediction}{plm}(model, data = find_data(model, parent.frame()),
  at = NULL, ...)

\method{prediction}{polr}(model, data = find_data(model, parent.frame()),
  at = NULL, type = NULL, category, ...)

\method{prediction}{ppr}(model, data = find_data(model, parent.frame()),
  at = NULL, ...)

\method{prediction}{princomp}(model, data = find_data(model, parent.frame()),
  at = NULL, ...)

\method{prediction}{rlm}(model, data = find_data(model, parent.frame()),
  at = NULL, type = "response", ...)

\method{prediction}{rq}(model, data = find_data(model, parent.frame()),
  at = NULL, ...)

\method{prediction}{selection}(model, data = find_data(model, parent.frame()),
  at = NULL, type = "response", ...)

\method{prediction}{survreg}(model, data = find_data(model, parent.frame()),
  at = NULL, type = c("response", "lp", "quantile", "uquantile"), ...)

\method{prediction}{svm}(model, data = NULL, at = NULL, category, ...)

\method{prediction}{svyglm}(model, data = find_data(model, parent.frame()),
  at = NULL, type = c("response", "link"), ...)

\method{prediction}{zeroinfl}(model, data = find_data(model, parent.frame()),
  at = NULL, type = c("response", "count", "prob", "zero"), ...)
}
\arguments{
\item{model}{A model object, perhaps returned by \code{\link[stats]{lm}} or \code{\link[stats]{glm}}.}

\item{\dots}{Additional arguments passed to \code{\link[stats]{predict}} methods.}

\item{data}{A data.frame over which to calculate marginal effects. If missing, \code{\link{find_data}} is used to specify the data frame.}

\item{at}{A list of one or more named vectors, specifically values at which to calculate the predictions. These are used to modify the value of \code{data} (see \code{\link{build_datalist}} for details on use).}

\item{type}{A character string indicating the type of marginal effects to estimate. Mostly relevant for non-linear models, where the reasonable options are \dQuote{response} (the default) or \dQuote{link} (i.e., on the scale of the linear predictor in a GLM). For models of class \dQuote{polr} (from \code{\link[MASS]{polr}}), possible values are \dQuote{class} or \dQuote{probs}; both are returned.}

\item{category}{For multi-level or multi-category outcome models (e.g., ordered probit, multinomial logit, etc.), a value specifying which of the outcome levels should be used for the \code{"fitted"} column. If missing, some default is chosen automatically.}
}
\value{
A data frame with class \dQuote{prediction} that has a number of rows equal to number of rows in \code{data}, or a multiple thereof, if \code{!is.null(at)}. The return value contains \code{data} (possibly modified by \code{at} using \code{\link{build_datalist}}), plus a column containing fitted/predicted values (\code{"fitted"}) and a column containing the standard errors thereof (\code{"se.fitted"}). Additional columns may be reported depending on the object class.
}
\description{
Extract predicted values via \code{\link[stats]{predict}} from a model object, conditional on data, and return a data frame.
}
\details{
This function is simply a wrapper around \code{\link[stats]{predict}} that returns a data frame containing the value of \code{data} and the predicted values with respect to all variables specified in \code{data}.

Methods are currently implemented for the following object classes:
\itemize{
  \item \dQuote{lm}, see \code{\link[stats]{lm}}
  \item \dQuote{glm}, see \code{\link[stats]{glm}}, \code{\link[MASS]{glm.nb}}, \code{\link[glmx]{glmx}}, \code{\link[glmx]{hetglm}}, \code{\link[brglm]{brglm}}
  \item \dQuote{ar}, see \code{\link[stats]{ar}}
  \item \dQuote{Arima}, see \code{\link[stats]{arima}}
  \item \dQuote{arima0}, see \code{\link[stats]{arima0}}
  \item \dQuote{betareg}, see \code{\link[betareg]{betareg}}
  \item \dQuote{clm}, see \code{\link[ordinal]{clm}}
  \item \dQuote{coxph}, see \code{\link[survival]{coxph}}
  \item \dQuote{crch}, see \code{\link[crch]{crch}}
  \item \dQuote{gam}, see \code{\link[gam]{gam}}
  \item \dQuote{gee}, see \code{\link[gee]{gee}}
  \item \dQuote{gls}, see \code{\link[nlme]{gls}}
  \item \dQuote{hurdle}, see \code{\link[pscl]{hurdle}}
  \item \dQuote{hxlr}, see \code{\link[crch]{hxlr}}
  \item \dQuote{ivreg}, see \code{\link[AER]{ivreg}}
  \item \dQuote{lda}, see \code{\link[MASS]{lda}}
  \item \dQuote{lme}, see \code{\link[nlme]{lme}}
  \item \dQuote{loess}, see \code{\link[stats]{loess}}
  \item \dQuote{lqs}, see \code{\link[MASS]{lqs}}
  \item \dQuote{mca}, see \code{\link[MASS]{mca}}
  \item \dQuote{mclogit}, see \code{\link[mclogit]{mclogit}}
  \item \dQuote{merMod}, see \code{\link[lme4]{lmer}}, \code{\link[lme4]{glmer}}
  \item \dQuote{mnlogit}, see \code{\link[mnlogit]{mnlogit}}
  \item \dQuote{mnp}, see \code{\link[MNP]{mnp}}
  \item \dQuote{naiveBayes}, see \code{\link[e1071]{naiveBayes}}
  \item \dQuote{nlme}, see \code{\link[nlme]{nlme}}
  \item \dQuote{nls}, see \code{\link[stats]{nls}}
  \item \dQuote{nnet}, see \code{\link[nnet]{nnet}}
  \item \dQuote{plm}, see \code{\link[plm]{plm}}
  \item \dQuote{polr}, see \code{\link[MASS]{polr}}
  \item \dQuote{ppr}, see \code{\link[stats]{ppr}}
  \item \dQuote{princomp}, see \code{\link[stats]{princomp}}
  \item \dQuote{qda}, see \code{\link[MASS]{qda}}
  \item \dQuote{rlm}, see \code{\link[MASS]{rlm}}
  \item \dQuote{rq}, see \code{\link[quantreg]{rq}}
  \item \dQuote{selection}, see \code{\link[sampleSelection]{selection}}
  \item \dQuote{survreg}, see \code{\link[survival]{survreg}}
  \item \dQuote{svm}, see \code{\link[e1071]{svm}}
  \item \dQuote{svyglm}, see \code{\link[survey]{svyglm}}
  \item \dQuote{zeroinfl}, see \code{\link[pscl]{zeroinfl}}
}
}
\examples{
require("datasets")
x <- lm(Petal.Width ~ Sepal.Length * Sepal.Width * Species, data = iris)
# prediction for every case
prediction(x)

# prediction for first case
prediction(x, iris[1,])

# basic use of 'at' argument
prediction(x, at = list(Species = c("setosa", "virginica")))

# prediction at means/modes of input variables
prediction(x, at = lapply(iris, mean_or_mode))

# prediction with multi-category outcome
\dontrun{
  library("mlogit")
  data("Fishing", package = "mlogit")
  Fish <- mlogit.data(Fishing, varying = c(2:9), shape = "wide", choice = "mode")
  mod <- mlogit(mode ~ price + catch, data = Fish)
  prediction(mod)
  prediction(mod, category = 3)
}

}
\seealso{
\code{\link{find_data}}, \code{\link{build_datalist}}, \code{\link{mean_or_mode}}, \code{\link{seq_range}}
}
\keyword{models}
