% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04Preprosim.R
\name{preprosimrun}
\alias{preprosimrun}
\title{Run data quality simulation}
\usage{
preprosimrun(data, param = newparam(data, "default"), seed = 1,
  caretmodel = "gbm", holdoutrounds = 10, cores = 1, verbose = TRUE)
}
\arguments{
\item{data}{(data frame) one factor columns for class labels, other columns numeric, no missing values}

\item{param}{(preprosimparameter object) simulation parameters, defaults to parameters set automatically for data.}

\item{seed}{(integer) seed to be used for reproducible results, defaults to 1}

\item{caretmodel}{(character) a model from package Caret, defaults to gbm (gbm must be installed before preprosimrun)}

\item{holdoutrounds}{(integer) number of holdout rounds, defaults to 10}

\item{cores}{(integer) number of cores used in parallel processing, defaults to 1}

\item{verbose}{(boolean) progress information outputted, defaults to TRUE}
}
\value{
preprosimanalysis class object
}
\description{
Run data quality simulation
}
\details{
caretmodel must be able to deal with missing values and preferably have in-build variable importance
such as rpart and gbm. Note: caret message will be outputted regardless of verbose.
}
\examples{
## res <- preprosimrun(iris)
## res1 <- preprosimrun(iris, param=newparam(iris, "custom", x="misval", z="noise"), cores=2)
## res2 <- preprosimrun(iris, caretmodel="rpart")
}

