% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form_to_json.R, R/prereg_spec_to_json.R,
%   R/prereg_spec_to_yaml.R
\name{form_to_json}
\alias{form_to_json}
\alias{prereg_spec_to_json}
\alias{print.preregr_json}
\alias{prereg_spec_to_yaml}
\alias{print.preregr_yaml}
\title{Convert a (pre)registration specification to YAML or JSON}
\usage{
form_to_json(x, file = NULL)

prereg_spec_to_json(x, includeFormSpec = TRUE, file = NULL)

\method{print}{preregr_json}(x, ...)

prereg_spec_to_yaml(x, includeFormSpec = TRUE, file = NULL)

\method{print}{preregr_yaml}(x, ...)
}
\arguments{
\item{x}{The (pre)registration object (as produced by a call to
\code{\link[=prereg_initialize]{prereg_initialize()}}), or, for the print method, the produced
YAML or JSON.}

\item{file}{Optionally, a file to save the YAML or JSON to.}

\item{includeFormSpec}{Whether to include the (pre)registration form
specification. Note that this includes metadata about the form fields
such as their labels and descriptions - without the form specification,
only the item identifiers are stored.}

\item{...}{Any additional arguments are ignored.}
}
\value{
If a file is specified to write, to, \code{x} will be returned invisibly
to allow building a pipe chain; if \code{file=NULL}, the resulting YAML/JSON
will be returned as a character vector.
}
\description{
Convert a (pre)registration specification to YAML or JSON
}
\examples{
preregr::prereg_initialize(
  "inclSysRev_v0_92"
) |>
  preregr::prereg_specify(
    title = "Example Study",
      authors = "Littlebottom, C., Dibbler, C., & Aching, T.",
    nonExistent_item = "This can't be stored anywhere"
  ) |>
  preregr::prereg_spec_to_json();
preregr::prereg_initialize(
  "inclSysRev_v0_92"
) |>
  preregr::prereg_specify(
    title = "Example Study",
      authors = "Littlebottom, C., Dibbler, C., & Aching, T.",
    nonExistent_item = "This can't be stored anywhere"
  ) |>
  preregr::prereg_spec_to_yaml();
}
