% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prereg_show_item_completion.R
\name{prereg_show_item_completion}
\alias{prereg_show_item_completion}
\title{Show which items in a (pre)registration have been completed}
\usage{
prereg_show_item_completion(x, section = NULL)
}
\arguments{
\item{x}{The (pre)registration object (as produced by a call to
\code{\link[=prereg_initialize]{prereg_initialize()}}).}

\item{section}{The section(s) to show; pass \code{NULL} (the default) to show
everything.}
}
\value{
x, invisibly
}
\description{
This function shows which items in a (pre)registration, or in one or more
sections, have been completed - or, more accurately, contain at least some
content that is different from the default content.
}
\examples{
### Load an example (pre)registration specification
data("examplePrereg_1", package = "preregr");

### Show which items were completed
examplePrereg_1 |>
  preregr::prereg_show_item_completion(
    section="metadata"
  );
}
