% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/o2_unit_conv.R
\encoding{UTF-8}
\name{o2_unit_conv}
\alias{o2_unit_conv}
\title{Convert units of dissolved oxygen}
\usage{
o2_unit_conv(o2 = 100, from = "percent_a.s.", to = "all", salinity = 35,
  temp = 25, air_pres = 1.013253)
}
\arguments{
\item{o2}{a numeric vector of the O2 value(s). Default is 100.}

\item{from}{a string describing the unit used to measure \code{o2}. Default is "percent_a.s." Options are:\describe{
\item{percent_a.s. (percent air saturation)}{}
\item{percent_o2}{}
\item{hPa}{}
\item{kPa}{}
\item{torr}{}
\item{mmHg}{}
\item{inHg}{}
\item{mg_per_l}{}
\item{umol_per_l}{}
\item{ml_per_l}{}
}}

\item{to}{a single string either describing the unit to which the conversion should be conducted (options are the same as in \code{from}), or the string "all" to return all units.}

\item{salinity}{salinity of water sample (psu). Default is 35 psu.}

\item{temp}{temperature of water sample (°C). Default is 25 °C.}

\item{air_pres}{pressure of air overlying water sample (bar). Default is 1.013253 bar.}
}
\description{
Given a measurement of dissolved O2, a list of commonly used units of oxygen partial pressures and concentrations are returned.
}
\details{
Conversions are based on relationships and values from the package \code{\link[marelac]{marelac}}.
}
\examples{
o2_unit_conv(o2 = 50)
o2_unit_conv(o2 = 1:50, from = "umol_per_l", to = "ml_per_l", salinity = 0, temp = 10,
	air_pres = 1.2)
o2_unit_conv()[c('mmHg','kPa')]

}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}

