% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_measures.R
\name{prec_lim_agree}
\alias{prec_lim_agree}
\title{Sample size or precision for limit of agreement on Bland-Altman plots}
\usage{
prec_lim_agree(n = NULL, conf.width = NULL, conf.level = 0.95)
}
\arguments{
\item{n}{sample size.}

\item{conf.width}{precision (the full width of the confidence interval).}

\item{conf.level}{confidence level.}
}
\value{
Object of class "presize", a list of arguments (including the
  computed one) augmented with method and note elements.
}
\description{
\code{prec_lim_agree} returns the sample size or the precision for the limit
of agreement, i.e. the confidence interval around the limit of agreement,
expressed in SD-units. It is an approximation based on the Normal distribution,
instead of a Student t distribution.
}
\details{
Exactly one of the parameters \code{n} or \code{conf.width} must be passed as NULL,
and that parameter is determined from the other.

The sample size and precision are calculated according to formulae in Bland &
Altman (1986).
}
\references{
Bland & Altman (1986) \emph{Statistical methods for assessing agreement
between two methods of clinical measurement} Lancet i(8476):307-310
\href{https://doi.org/10.1016/S0140-6736(86)90837-8}{doi:10.1016/S0140-6736(86)90837-8}
}
