% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressuRe_functions.R
\name{load_emed}
\alias{load_emed}
\title{Load emed data}
\usage{
load_emed(pressure_filepath)
}
\arguments{
\item{pressure_filepath}{String. Filepath pointing to emed pressure file}
}
\value{
A list with information about the pressure data.
\itemize{
  \item pressure_array. 3D array covering each timepoint of the measurement.
           z dimension represents time
  \item pressure_system. String defining pressure system
  \item sens_size. Numeric vector with the areas of the sensors
  \item time. Numeric value for time between measurements
  \item masks. List
  \item events. List
  \item sensor_polygons. Data frame with corners of sensors
  \item max_matrix Matrix with maximum image
 }
}
\description{
Imports and formats .lst files collected on emed system and
   exported from Novel software
}
\examples{
emed_data <- system.file("extdata", "emed_test.lst", package = "pressuRe")
pressure_data <- load_emed(emed_data)
}
