% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressuRe_functions.R
\name{create_mask_manual}
\alias{create_mask_manual}
\title{Create masking}
\usage{
create_mask_manual(
  pressure_data,
  mask_definition = "by_vertices",
  n_masks = 1,
  n_verts = 4,
  n_sens = 4,
  threshold = 0.005,
  plot_existing_masks = TRUE,
  mask_names = "default",
  plot = TRUE
)
}
\arguments{
\item{pressure_data}{List. First item is a matrix covering each timepoint
of the measurement.}

\item{mask_definition}{String. "by_vertices" or "by_sensors". The first
option let's you draw a shape around the area you want to select, the
second allows you to define this area by clicking on specific sensors}

\item{n_masks}{Numeric. Number of masks to add}

\item{n_verts}{Numeric. Number of vertices in mask}

\item{n_sens}{Numeric. Number of sensors mask will contain}

\item{threshold}{Numeric. Distance between adjacent mask vertices before
sharing vertex coordinates}

\item{plot_existing_masks}{Logical. Show existing masks}

\item{mask_names}{List. Mask names. Default is "custom_mask#"}

\item{plot}{Logical. Show new maks on pressure image}
}
\value{
List. Mask(s) are added to pressure data variable
\itemize{
  \item pressure_array. 3D array covering each timepoint of the measurement.
           z dimension represents time
  \item pressure_system. String defining pressure system
  \item sens_size. Numeric vector with the dimensions of the sensors
  \item time. Numeric value for time between measurements
  \item masks. List
  \item events. List
  \item sensor_polygons. Data frame with corners of sensors
  \item max_matrix Matrix with maximum image
 }
}
\description{
Allows user to manually define mask regions
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
emed_data <- system.file("extdata", "emed_test.lst", package = "pressuRe")
pressure_data <- load_emed(emed_data)
pressure_data <- create_mask_manual(pressure_data, mask_definition = "by_vertices",
n_masks = 1, n_verts = 4)
pressure_data <- create_mask_manual(pressure_data, mask_definition = "by_sensors",
n_masks = 1, n_sens = 8)
\dontshow{\}) # examplesIf}
}
