% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prettify_FCA.R
\name{prettify_FCA}
\alias{prettify_FCA}
\title{Prettify Java, JSON or Ruby}
\usage{
prettify_FCA(contents = NA, language = NA)
}
\arguments{
\item{contents}{the code to be prettified; there are three possibilities for
this argument:
\code{NA} (default), to use the file currently opened in RStudio;
the path to a file;
or the code given as a character vector}

\item{language}{the language of the code, such as \code{"json"};
see \code{\link{getPrettifiableLanguages}};
if the contents are read from a file and \code{language=NA}, then the
language is guessed from the file extension}
}
\value{
The pretty code in a character string.
}
\description{
Prettify Java code, JSON code or Ruby code.
}
\note{
This function requires a connection to Internet.
}
\examples{
library(prettifyAddins)

code <- c(
  "{a: [0,1,  2   ],",
  "f:  function( x){return x+1}}" # this function will be prettified too
)

\dontrun{
cat(prettify_FCA(code, "json"))}
}
