% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bboxtools.R
\name{zoombbox}
\alias{zoombbox}
\title{Zoom the extents of a bounding box}
\usage{
zoombbox(bbox, factor = 1, offset = c(0, 0))
}
\arguments{
\item{bbox}{An existing bbox}

\item{factor}{A factor to zoom by. >1 will zoom in, <1 will zoom out.
If a vector is passed, the first element will zoom the X extent, the
second element will zoom the Y extent.}

\item{offset}{A vector describing the X and Y offset that should be applied.}
}
\value{
A zoomed bounding box.
}
\description{
Manipulate the extents of a bounding box by zooming and moving an
existing bbox. This is helpful when manipulating the extents of a
plot created by \code{canvec.qplot()}
}
\examples{
\donttest{
alta <- searchbbox("alta lake bc", source="google")
zoombbox(alta, c(.2,.5))
}
}

